/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.proxy;

import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.CustomStateMapper;
import com.lothrazar.simpletomb.block.RenderTomb;
import com.lothrazar.simpletomb.block.TileEntityTomb;
import com.lothrazar.simpletomb.event.ClientEvents;
import com.lothrazar.simpletomb.item.ItemGraveKey;
import com.lothrazar.simpletomb.particle.ParticleCasting;
import com.lothrazar.simpletomb.particle.ParticleGraveSmoke;
import com.lothrazar.simpletomb.particle.ParticleGraveSoul;
import com.lothrazar.simpletomb.proxy.CommonProxy;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void init() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTomb.class, (TileEntitySpecialRenderer)new RenderTomb());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
    }

    @Override
    public void produceGraveSmoke(World world, BlockPos pos) {
        int fogDensity = world.field_73012_v.nextInt(FogDensity.values().length);
        for (int i = 0; i <= fogDensity; ++i) {
            ParticleGraveSmoke particle = new ParticleGraveSmoke(world, (double)pos.func_177958_n() + world.field_73012_v.nextGaussian(), (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + world.field_73012_v.nextGaussian(), (double)(world.field_73012_v.nextFloat() - 0.5f) * 0.03, 0.0, (double)(world.field_73012_v.nextFloat() - 0.5f) * 0.03);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
        }
    }

    @Override
    public void produceGraveSoul(World world, BlockPos pos) {
        ParticleGraveSoul particle = new ParticleGraveSoul(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.3);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
    }

    @Override
    public void produceParticleCasting(EntityLivingBase caster, Predicate<EntityLivingBase> predic) {
        if (caster != null) {
            for (int i = 1; i <= 2; ++i) {
                ParticleCasting particle = new ParticleCasting(caster.field_70170_p, caster, predic, 0.0, (double)i * 0.5);
                ParticleManager er = Minecraft.func_71410_x().field_71452_i;
                er.func_78873_a((Particle)particle);
                particle = new ParticleCasting(caster.field_70170_p, caster, predic, 0.5, (double)(i + 1) * 0.5);
                er.func_78873_a((Particle)particle);
                particle = new ParticleCasting(caster.field_70170_p, caster, predic, 1.0, (double)i * 0.5);
                er.func_78873_a((Particle)particle);
                particle = new ParticleCasting(caster.field_70170_p, caster, predic, 1.5, (double)(i + 1) * 0.5);
                er.func_78873_a((Particle)particle);
                particle = new ParticleCasting(caster.field_70170_p, caster, predic, 2.0, (double)i * 0.5);
                er.func_78873_a((Particle)particle);
            }
        }
    }

    @Override
    public void registerModels() {
        for (int i = 0; i < TombRegistry.graves.length; ++i) {
            ModelLoader.setCustomStateMapper((Block)TombRegistry.graves[i], (IStateMapper)new CustomStateMapper());
        }
        ItemGraveKey item = TombRegistry.grave_key;
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    public static enum FogDensity {
        NONE,
        LOW,
        NORMAL,
        HIGH;

    }
}

