/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.helper;

import com.lothrazar.simpletomb.data.LocationBlockPos;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class NBTHelper {
    private static NBTTagCompound getOrCreateTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    private static void setBlockPos(NBTTagCompound tag, String keyName, BlockPos keyValue) {
        tag.func_74768_a(keyName + "X", keyValue.func_177958_n());
        tag.func_74768_a(keyName + "Y", keyValue.func_177956_o());
        tag.func_74768_a(keyName + "Z", keyValue.func_177952_p());
    }

    private static BlockPos getBlockPos(@Nullable NBTTagCompound tag, String keyName) {
        return tag != null && tag.func_74764_b(keyName + "X") && tag.func_74764_b(keyName + "Y") && tag.func_74764_b(keyName + "Z") ? new BlockPos(tag.func_74762_e(keyName + "X"), tag.func_74762_e(keyName + "Y"), tag.func_74762_e(keyName + "Z")) : LocationBlockPos.ORIGIN_POS;
    }

    public static ItemStack setLocation(ItemStack stack, String keyName, LocationBlockPos location) {
        NBTHelper.setLocation(NBTHelper.getOrCreateTag(stack), keyName, location);
        return stack;
    }

    private static NBTTagCompound setLocation(NBTTagCompound tag, String keyName, LocationBlockPos location) {
        NBTHelper.setBlockPos(tag, keyName, location.toBlockPos());
        tag.func_74768_a(keyName + "D", location.dim);
        return tag;
    }

    public static LocationBlockPos getLocation(ItemStack stack, String keyName) {
        return NBTHelper.getLocation(NBTHelper.getOrCreateTag(stack), keyName);
    }

    private static LocationBlockPos getLocation(@Nullable NBTTagCompound tag, String keyName) {
        BlockPos pos;
        if (tag != null && tag.func_74764_b(keyName + "D") && !(pos = NBTHelper.getBlockPos(tag, keyName)).equals((Object)LocationBlockPos.ORIGIN_POS)) {
            return new LocationBlockPos(pos, tag.func_74762_e(keyName + "D"));
        }
        return LocationBlockPos.ORIGIN;
    }
}

