/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.event;

import com.lothrazar.simpletomb.ConfigTomb;
import com.lothrazar.simpletomb.ModTomb;
import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.BlockTomb;
import com.lothrazar.simpletomb.block.TileEntityTomb;
import com.lothrazar.simpletomb.data.LocationBlockPos;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.helper.EntityHelper;
import com.lothrazar.simpletomb.helper.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.Level;

public class PlayerTombEvents {
    private static final String TB_SOULBOUND_STACKS = "tb_soulbound_stacks";

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerLogged(PlayerEvent.PlayerLoggedInEvent event) {
        if (EntityHelper.isValidPlayerMP((Entity)event.player)) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            assert (player.func_184102_h() != null);
            NBTTagCompound playerData = player.getEntityData();
            if (playerData.func_74764_b("PlayerPersisted")) {
                NBTTagCompound persistantData = (NBTTagCompound)playerData.func_74781_a("PlayerPersisted");
            } else {
                NBTTagCompound persistantData = new NBTTagCompound();
                playerData.func_74782_a("PlayerPersisted", (NBTBase)persistantData);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(blockPos -> event.getWorld().func_180495_p(blockPos).func_177230_c() instanceof BlockTomb);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (EntityHelper.isValidPlayerMP((Entity)event.player) && !event.player.func_175149_v()) {
            NBTTagCompound persistentTag = EntityHelper.getPersistentTag(event.player);
            NBTTagList stackList = persistentTag.func_150295_c(TB_SOULBOUND_STACKS, 10);
            for (int i = 0; i < stackList.func_74745_c(); ++i) {
                ItemStack stack = new ItemStack(stackList.func_150305_b(i));
                if (stack.func_190926_b()) continue;
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.player, (ItemStack)stack);
            }
            persistentTag.func_82580_o(TB_SOULBOUND_STACKS);
            event.player.field_71069_bz.func_75142_b();
        }
    }

    private void storeSoulboundsOnBody(EntityPlayer player, List<ItemStack> keys) {
        NBTTagCompound persistentTag = EntityHelper.getPersistentTag(player);
        NBTTagList stackList = new NBTTagList();
        persistentTag.func_74782_a(TB_SOULBOUND_STACKS, (NBTBase)stackList);
        for (ItemStack key : keys) {
            stackList.func_74742_a((NBTBase)key.serializeNBT());
        }
        keys.clear();
    }

    private void storeIntegerStorageMap(EntityPlayer player) {
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (!ConfigTomb.INSTANCE.handlePlayerDeath) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            this.storeIntegerStorageMap(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onPlayerDrops(PlayerDropsEvent event) {
        boolean hasDrop;
        if (!ConfigTomb.INSTANCE.handlePlayerDeath) {
            return;
        }
        if (!EntityHelper.isValidPlayer((Entity)event.getEntityPlayer()) || WorldHelper.isRuleKeepInventory(event.getEntityPlayer())) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
        WorldServer world = player.func_71121_q();
        ListIterator it = event.getDrops().listIterator();
        ArrayList<ItemStack> keys = new ArrayList<ItemStack>();
        while (it.hasNext()) {
            ItemStack stack;
            EntityItem entityItem = (EntityItem)it.next();
            if (entityItem == null || entityItem.func_92059_d().func_190926_b() || (stack = entityItem.func_92059_d()).func_77973_b() != TombRegistry.grave_key) continue;
            keys.add(stack.func_77946_l());
            it.remove();
        }
        List<EntityItem> itemsPickedUpFromGround = this.pickupFromGround(player, keys);
        this.storeSoulboundsOnBody((EntityPlayer)player, keys);
        boolean bl = hasDrop = event.getDrops().size() > 0 || itemsPickedUpFromGround.size() > 0;
        if (!hasDrop) {
            MessageType.MESSAGE_NO_LOOT_FOR_GRAVE.sendSpecialMessage((ICommandSender)player, new Object[0]);
            return;
        }
        BlockPos initPos = WorldHelper.getCloserValidPos((World)world, new BlockPos((Entity)player));
        LocationBlockPos spawnPos = WorldHelper.findGraveSpawn((EntityPlayer)player, initPos);
        if (spawnPos == null) {
            MessageType.MESSAGE_NO_PLACE_FOR_GRAVE.sendSpecialMessage((ICommandSender)player, new Object[0]);
            ModTomb.LOGGER.log(Level.INFO, MessageType.MESSAGE_NO_PLACE_FOR_GRAVE.getServerTranslation(new Object[0]));
            return;
        }
        EnumFacing facing = player.func_174811_aO().func_176734_d();
        IBlockState state = TombRegistry.graves[world.field_73012_v.nextInt(TombRegistry.graves.length)].func_176223_P();
        state = state.func_177226_a((IProperty)BlockTomb.FACING, (Comparable)facing);
        state = state.func_177226_a((IProperty)BlockTomb.HAS_SOUL, (Comparable)Boolean.valueOf(world.field_73012_v.nextDouble() > 0.5));
        state = state.func_177226_a((IProperty)BlockTomb.MODEL_TEXTURE, (Comparable)Integer.valueOf(world.field_73012_v.nextInt(2)));
        WorldHelper.placeNoEvent((World)world, spawnPos.toBlockPos(), state);
        TileEntity tile = world.func_175625_s(spawnPos.toBlockPos());
        if (!(tile instanceof TileEntityTomb)) {
            MessageType.MESSAGE_FAIL_TO_PLACE_GRAVE.sendSpecialMessage((ICommandSender)player, new Object[0]);
            ModTomb.LOGGER.log(Level.INFO, MessageType.MESSAGE_FAIL_TO_PLACE_GRAVE.getServerTranslation(new Object[0]));
            return;
        }
        TileEntityTomb grave = (TileEntityTomb)tile;
        grave.initTombstoneOwner((EntityPlayer)player);
        ModTomb.LOGGER.log(Level.INFO, MessageType.MESSAGE_NEW_GRAVE.getServerTranslation(new Object[0]));
        MessageType.MESSAGE_NEW_GRAVE.sendSpecialMessage((ICommandSender)player, new Object[0]);
        MessageType.MESSAGE_JOURNEYMAP.sendSpecialMessage((ICommandSender)player, spawnPos.x, spawnPos.y, spawnPos.z, spawnPos.dim);
        if (ConfigTomb.INSTANCE.graveKeyOnDeath) {
            ItemStack key = new ItemStack((Item)TombRegistry.grave_key);
            TombRegistry.grave_key.setTombPos(key, spawnPos);
            if (ConfigTomb.INSTANCE.addNameToPlayersKey) {
                key.func_151001_c(TextFormatting.GOLD + player.getDisplayNameString() + " " + key.func_82833_r());
            }
            keys.add(key);
        }
        this.storeSoulboundsOnBody((EntityPlayer)player, keys);
        IItemHandler itemHandler = (IItemHandler)grave.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (EntityItem entityItem : event.getDrops()) {
            if (entityItem.func_92059_d().func_190926_b()) continue;
            ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.func_92059_d().func_77946_l(), (boolean)false);
            entityItem.func_92058_a(ItemStack.field_190927_a);
        }
        for (EntityItem entityItem : itemsPickedUpFromGround) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.func_92059_d(), (boolean)false);
            entityItem.func_92058_a(ItemStack.field_190927_a);
        }
        world.func_184138_a(spawnPos.toBlockPos(), Blocks.field_150350_a.func_176223_P(), state, 2);
    }

    private List<EntityItem> pickupFromGround(EntityPlayerMP player, ArrayList<ItemStack> keys) {
        double range = ConfigTomb.INSTANCE.pickUpGroundRange;
        if (range == 0.0) {
            return new ArrayList<EntityItem>();
        }
        return player.field_70170_p.func_72872_a(EntityItem.class, new AxisAlignedBB(player.field_70165_t - range, player.field_70163_u - range, player.field_70161_v - range, player.field_70165_t + range, player.field_70163_u + range, player.field_70161_v + range));
    }

    @SubscribeEvent
    public static void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        String source = event.getSource() == null ? "" : event.getSource().getName() + " ";
        String msg = "simpletombInvalid fingerprint detected! The file " + source + "may have been tampered with. This version will NOT be supported by the author!";
        System.out.println(msg);
    }
}

