/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.block;

import com.google.common.base.Predicate;
import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.ModelTomb;
import com.lothrazar.simpletomb.block.TileEntityTomb;
import com.lothrazar.simpletomb.data.LocationBlockPos;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.helper.EntityHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTomb
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyInteger MODEL_TEXTURE = PropertyInteger.func_177719_a((String)"model_texture", (int)0, (int)1);
    public static final PropertyBool IS_ENGRAVED = PropertyBool.func_177716_a((String)"is_engraved");
    public static final PropertyBool HAS_SOUL = PropertyBool.func_177716_a((String)"has_soul");
    protected static final AxisAlignedBB ground_bounds = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    protected final String name;
    protected final ModelTomb graveModel;
    protected final HashMap<EnumFacing, List<AxisAlignedBB>> collisions = new HashMap();

    public BlockTomb(ModelTomb graveModel) {
        super(Material.field_151576_e);
        this.func_149647_a(null);
        this.func_149715_a(0.7f);
        this.func_149722_s();
        this.func_149711_c(4.0f);
        this.func_149752_b(1.8E7f);
        this.name = graveModel.func_176610_l();
        this.graveModel = graveModel;
        this.func_149663_c(this.name);
        this.setRegistryName(this.name);
        this.field_149783_u = true;
        this.func_149715_a(0.4f);
        this.func_149713_g(255);
        this.field_149762_H = SoundType.field_185851_d;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)MODEL_TEXTURE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)HAS_SOUL, (Comparable)Boolean.valueOf(false)));
        this.loadCollisions();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return -1.0f;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public ModelTomb getGraveType() {
        return this.graveModel;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public String func_149739_a() {
        return "simpletomb.grave." + this.name;
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        ItemStack heldStack = placer.func_184586_b(hand);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)IS_ENGRAVED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MODEL_TEXTURE, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)heldStack.func_77960_j(), (int)0, (int)1)));
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    protected boolean func_149700_E() {
        return false;
    }

    @Nullable
    public TileEntityTomb getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityTomb ? (TileEntityTomb)tile : null;
    }

    public TileEntityTomb createTileEntity(World world, IBlockState state) {
        return new TileEntityTomb();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HAS_SOUL, IS_ENGRAVED, MODEL_TEXTURE});
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity.func_70093_af() && !entity.field_70128_L && EntityHelper.isValidPlayer(entity)) {
            this.activatePlayerGrave(world, pos, state, (EntityPlayer)((EntityPlayerMP)entity));
        }
    }

    private void activatePlayerGrave(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityTomb tile = this.getTileEntity((IBlockAccess)world, pos);
        if (tile != null && player.func_70089_S()) {
            if (tile.onlyOwnersCanAccess() && !tile.isOwner(player)) {
                MessageType.MESSAGE_OPEN_GRAVE_NEED_OWNER.sendSpecialMessage((ICommandSender)player, new Object[0]);
            } else {
                tile.giveInventory(player);
                TombRegistry.grave_key.removeKeyForGraveInInventory(player, new LocationBlockPos(pos, world));
            }
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityTomb tile = this.getTileEntity(world, pos);
        return state.func_177226_a((IProperty)IS_ENGRAVED, (Comparable)Boolean.valueOf(tile != null && tile.hasOwner()));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)MODEL_TEXTURE, (Comparable)Integer.valueOf((meta & 4) == 0 ? 0 : 1)).func_177226_a((IProperty)HAS_SOUL, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((Integer)state.func_177229_b((IProperty)MODEL_TEXTURE) == 0 ? 0 : 4) + ((Boolean)state.func_177229_b((IProperty)HAS_SOUL) != false ? 8 : 0);
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MODEL_TEXTURE);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemStack.field_190927_a.func_77973_b();
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing facing) {
        return facing == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        List<AxisAlignedBB> collisionList = this.collisions.get(facing);
        for (AxisAlignedBB collision : collisionList) {
            BlockTomb.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)collision);
        }
        BlockTomb.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)ground_bounds);
    }

    private void loadCollisions() {
        switch (this.graveModel) {
            case GRAVE_CROSS: {
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.40625, 0.125, 0.6875, 0.59375, 0.9375, 0.875));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.40625, 0.125, 0.125, 0.59375, 0.9375, 0.3125));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.6875, 0.125, 0.40625, 0.875, 0.9375, 0.59375));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.125, 0.125, 0.40625, 0.3125, 0.9375, 0.59375));
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.21875, 0.5625, 0.6875, 0.78125, 0.75, 0.875));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.21875, 0.5625, 0.125, 0.78125, 0.75, 0.3125));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.6875, 0.5625, 0.21875, 0.875, 0.75, 0.78125));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.125, 0.5625, 0.21875, 0.3125, 0.75, 0.78125));
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.28125, 0.0625, 0.5625, 0.71875, 0.125, 1.0));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.28125, 0.0625, 0.0, 0.71875, 0.125, 0.4375));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.5625, 0.0625, 0.28125, 1.0, 0.125, 0.71875));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.0, 0.0625, 0.28125, 0.4375, 0.125, 0.71875));
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.34375, 0.125, 0.625, 0.65625, 0.1875, 0.9375));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.34375, 0.125, 0.0625, 0.65625, 0.1875, 0.375));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.625, 0.125, 0.34375, 0.9375, 0.1875, 0.65625));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.0625, 0.125, 0.34375, 0.375, 0.1875, 0.65625));
                break;
            }
            case GRAVE_NORMAL: {
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.1875, 0.0625, 0.0, 0.8125, 0.28125, 1.0));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.1875, 0.0625, 0.0, 0.8125, 0.28125, 1.0));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.0, 0.0625, 0.1875, 1.0, 0.28125, 0.8125));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.0, 0.0625, 0.1875, 1.0, 0.28125, 0.8125));
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.1875, 0.25, 0.875, 0.8125, 0.875, 1.0));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.1875, 0.25, 0.0, 0.8125, 0.875, 0.125));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.875, 0.25, 0.1875, 1.0, 0.875, 0.8125));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.0, 0.25, 0.1875, 0.125, 0.875, 0.8125));
                break;
            }
            case GRAVE_SIMPLE: {
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.1875, 0.0625, 0.8125, 0.8125, 0.875, 1.0));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.1875, 0.0625, 0.0, 0.8125, 0.875, 0.1875));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.8125, 0.0625, 0.1875, 1.0, 0.875, 0.8125));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.0, 0.0625, 0.1875, 0.1875, 0.875, 0.8125));
                break;
            }
            default: {
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.03125, 0.0625, 0.21875, 0.96875, 0.64375, 0.96875));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.03125, 0.0625, 0.03125, 0.96875, 0.64375, 0.78125));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.21875, 0.0625, 0.03125, 0.96875, 0.64375, 0.96875));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.03125, 0.0625, 0.03125, 0.78125, 0.64375, 0.96875));
                this.addCollision(EnumFacing.NORTH, new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.9375, 0.09375, 0.21875));
                this.addCollision(EnumFacing.SOUTH, new AxisAlignedBB(0.0625, 0.0625, 0.78125, 0.9375, 0.09375, 0.9375));
                this.addCollision(EnumFacing.WEST, new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.21875, 0.09375, 0.9375));
                this.addCollision(EnumFacing.EAST, new AxisAlignedBB(0.78125, 0.0625, 0.0625, 0.9375, 0.09375, 0.9375));
            }
        }
    }

    private void addCollision(EnumFacing facing, AxisAlignedBB bounds) {
        List listCollisions = this.collisions.computeIfAbsent(facing, k -> new ArrayList());
        listCollisions.add(bounds);
        this.collisions.put(facing, listCollisions);
    }

    @Nullable
    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        return EnumFacing.field_176754_o;
    }
}

