/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.itemfilters.net;

import com.latmod.mods.itemfilters.api.IItemFilter;
import com.latmod.mods.itemfilters.api.ItemFiltersAPI;
import com.latmod.mods.itemfilters.net.ItemFiltersNetHandler;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageUpdateItem
implements IMessage {
    private EnumHand hand;
    private NBTTagCompound nbt;

    public MessageUpdateItem() {
    }

    public MessageUpdateItem(EnumHand h, IItemFilter filter) {
        NBTBase nbt1;
        this.hand = h;
        if (filter instanceof INBTSerializable && (nbt1 = ((INBTSerializable)filter).serializeNBT()) != null) {
            this.nbt = new NBTTagCompound();
            this.nbt.func_74782_a("x", nbt1);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.hand = buf.readBoolean() ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.hand != EnumHand.MAIN_HAND);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public void send() {
        ItemFiltersNetHandler.NET.sendToServer((IMessage)this);
    }

    public static class Handler
    implements IMessageHandler<MessageUpdateItem, IMessage> {
        @Nullable
        public IMessage onMessage(MessageUpdateItem message, MessageContext ctx) {
            if (message.nbt != null) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                player.field_71133_b.func_152344_a(() -> {
                    ItemStack stack = player.func_184586_b(message.hand);
                    IItemFilter filter = ItemFiltersAPI.getFilter(stack);
                    if (filter instanceof INBTSerializable) {
                        ((INBTSerializable)filter).deserializeNBT(message.nbt.func_74781_a("x"));
                    }
                });
            }
            return null;
        }
    }
}

