/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.itemfilters.item;

import com.latmod.mods.itemfilters.ItemFilters;
import com.latmod.mods.itemfilters.api.IItemFilter;
import com.latmod.mods.itemfilters.api.IRegisteredItemFilter;
import com.latmod.mods.itemfilters.api.ItemFiltersAPI;
import com.latmod.mods.itemfilters.filters.AlwaysTrueItemFilter;
import com.latmod.mods.itemfilters.filters.LogicFilter;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFilter
extends Item {
    public ItemFilterData initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ItemFilterData();
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        IItemFilter filter = ItemFiltersAPI.getFilter(stack);
        if (filter instanceof INBTSerializable || stack.func_77942_o()) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (stack.func_77978_p() != null) {
                nbt.func_74782_a("nbt", (NBTBase)stack.func_77978_p());
            }
            if (filter instanceof INBTSerializable) {
                nbt.func_74782_a("filter", ((INBTSerializable)filter).serializeNBT());
            }
            return nbt;
        }
        return null;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        NBTBase nbt1;
        stack.func_77982_d(nbt == null ? null : (NBTTagCompound)nbt.func_74781_a("nbt"));
        IItemFilter filter = ItemFiltersAPI.getFilter(stack);
        filter.resetData();
        if (nbt != null && filter instanceof INBTSerializable && (nbt1 = nbt.func_74781_a("filter")) != null) {
            ((INBTSerializable)filter).deserializeNBT(nbt1);
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Supplier<IRegisteredItemFilter> supplier : ItemFiltersAPI.REGISTRY.values()) {
                IRegisteredItemFilter filter = supplier.get();
                if (filter instanceof LogicFilter) continue;
                ItemStack stack = new ItemStack((Item)this);
                ((ItemFilterData)ItemFiltersAPI.getFilter((ItemStack)stack)).filter = filter;
                items.add((Object)stack);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IItemFilter filter = ItemFiltersAPI.getFilter(stack);
        if (filter instanceof ItemFilterData) {
            if (world.field_72995_K) {
                if (player.func_70093_af()) {
                    ItemFilters.PROXY.openSelectionGUI((ItemFilterData)filter, hand);
                } else {
                    ItemFilters.PROXY.openGUI(filter, hand);
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        IItemFilter filter = ItemFiltersAPI.getFilter(stack);
        if (filter instanceof ItemFilterData) {
            IRegisteredItemFilter f = ((ItemFilterData)filter).filter;
            tooltip.add(TextFormatting.ITALIC + I18n.func_135052_a((String)("filter.itemfilters." + f.getID() + ".name"), (Object[])new Object[0]));
            if (GuiScreen.func_146272_n()) {
                tooltip.add(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)("filter.itemfilters." + f.getID() + ".filter"), (Object[])new Object[0]));
            }
        }
    }

    public static class ItemFilterData
    implements IItemFilter,
    ICapabilitySerializable<NBTTagCompound> {
        public IRegisteredItemFilter filter = AlwaysTrueItemFilter.INSTANCE;

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == ItemFiltersAPI.CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == ItemFiltersAPI.CAPABILITY ? this : null);
        }

        public NBTTagCompound serializeNBT() {
            NBTBase nbt1;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("id", this.filter.getID());
            NBTBase nBTBase = nbt1 = this.filter instanceof INBTSerializable ? ((INBTSerializable)this.filter).serializeNBT() : null;
            if (nbt1 != null && !nbt1.func_82582_d()) {
                nbt.func_74782_a("data", nbt1);
            }
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.filter = ItemFiltersAPI.createFromID(nbt.func_74779_i("id"));
            if (this.filter == null) {
                this.filter = AlwaysTrueItemFilter.INSTANCE;
            }
            if (this.filter instanceof INBTSerializable && nbt.func_74764_b("data")) {
                ((INBTSerializable)this.filter).deserializeNBT(nbt.func_74781_a("data"));
            }
        }

        @Override
        public boolean filter(ItemStack stack) {
            return this.filter.filter(stack);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void openEditingGUI(Runnable save) {
            this.filter.openEditingGUI(save);
        }

        @Override
        public void getValidItems(List<ItemStack> list) {
            this.filter.getValidItems(list);
        }
    }
}

