/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.util;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.block.tile.LootrInventoryTileEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.DataStorage;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.networking.CloseCart;
import noobanidus.mods.lootr.networking.PacketHandler;

public class ChestUtil {
    public static Random random = new Random();
    public static Set<Class<?>> tileClasses = new HashSet();

    public static boolean handleLootSneak(Block block, World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            return false;
        }
        if (player.func_175149_v()) {
            player.func_71053_j();
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ILootTile) {
            Set<UUID> openers = ((ILootTile)te).getOpeners();
            openers.remove(player.func_110124_au());
            ((ILootTile)te).updatePacketViaState();
            return true;
        }
        return false;
    }

    public static void handleLootCartSneak(World world, LootrChestMinecartEntity cart, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        if (player.func_175149_v()) {
            return;
        }
        cart.getOpeners().remove(player.func_110124_au());
        CloseCart open = new CloseCart(cart.func_145782_y());
        PacketHandler.sendToAllTracking((Entity)cart, open);
    }

    public static boolean handleLootChest(Block block, World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            return false;
        }
        if (player.func_175149_v()) {
            player.func_71053_j();
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ILootTile) {
            int refreshValue;
            UUID tileId = ((ILootTile)te).getTileId();
            if (DataStorage.isDecayed(tileId)) {
                world.func_175655_b(pos, true);
                DataStorage.removeDecayed(tileId);
                player.func_146105_b(new TextComponentTranslation("lootr.message.decayed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150227_a(Boolean.valueOf(true))), true);
                return false;
            }
            int decayValue = DataStorage.getDecayValue(tileId);
            if (decayValue > 0 && ConfigManager.shouldNotify(decayValue)) {
                player.func_146105_b(new TextComponentTranslation("lootr.message.decay_in", new Object[]{decayValue / 20}).func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150227_a(Boolean.valueOf(true))), true);
            } else if (decayValue == -1 && ConfigManager.isDecaying(world, (ILootTile)te)) {
                DataStorage.setDecaying(tileId, ConfigManager.getDecayValue());
                player.func_146105_b(new TextComponentTranslation("lootr.message.decay_start", new Object[]{ConfigManager.getDecayValue() / 20}).func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150227_a(Boolean.valueOf(true))), true);
            }
            if (DataStorage.isRefreshed(tileId)) {
                DataStorage.refreshInventory(world, ((ILootTile)te).getTileId(), (EntityPlayerMP)player, pos);
                DataStorage.removeRefreshed(tileId);
                player.func_146105_b(new TextComponentTranslation("lootr.message.refreshed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE).func_150227_a(Boolean.valueOf(true))), true);
            }
            if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0 && ConfigManager.shouldNotify(refreshValue)) {
                player.func_146105_b(new TextComponentTranslation("lootr.message.refresh_in", new Object[]{refreshValue / 20}).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE).func_150227_a(Boolean.valueOf(true))), true);
            } else if (refreshValue == -1 && ConfigManager.isRefreshing(world, (ILootTile)te)) {
                DataStorage.setRefreshing(tileId, ConfigManager.getRefreshValue());
                player.func_146105_b(new TextComponentTranslation("lootr.message.refresh_start", new Object[]{ConfigManager.getRefreshValue() / 20}).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE).func_150227_a(Boolean.valueOf(true))), true);
            }
            SpecialChestInventory provider = DataStorage.getInventory(world, ((ILootTile)te).getTileId(), pos, (EntityPlayerMP)player, (TileEntityLockableLoot)te, ((ILootTile)te)::fillWithLoot);
            player.func_71007_a((IInventory)provider);
            return true;
        }
        return false;
    }

    public static void handleLootCart(World world, LootrChestMinecartEntity cart, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (player.func_175149_v()) {
                player.func_71053_j();
            } else {
                int refreshValue;
                UUID tileId = cart.func_110124_au();
                if (DataStorage.isDecayed(tileId)) {
                    cart.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
                    DataStorage.removeDecayed(tileId);
                    player.func_146105_b(new TextComponentTranslation("lootr.message.decayed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150227_a(Boolean.valueOf(true))), true);
                    return;
                }
                int decayValue = DataStorage.getDecayValue(tileId);
                if (decayValue > 0 && ConfigManager.shouldNotify(decayValue)) {
                    player.func_146105_b(new TextComponentTranslation("lootr.message.decay_in", new Object[]{decayValue / 20}).func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150227_a(Boolean.valueOf(true))), true);
                } else if (decayValue == -1 && ConfigManager.isDecaying(world, cart)) {
                    DataStorage.setDecaying(tileId, ConfigManager.getDecayValue());
                    player.func_146105_b(new TextComponentTranslation("lootr.message.decay_start", new Object[]{ConfigManager.getDecayValue() / 20}).func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150227_a(Boolean.valueOf(true))), true);
                }
                if (!cart.getOpeners().contains(player.func_110124_au())) {
                    cart.addOpener(player);
                }
                if (DataStorage.isRefreshed(tileId)) {
                    DataStorage.refreshInventory(world, cart, (EntityPlayerMP)player, cart.func_180425_c());
                    DataStorage.removeRefreshed(tileId);
                    player.func_146105_b(new TextComponentTranslation("lootr.message.refreshed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE).func_150227_a(Boolean.valueOf(true))), true);
                }
                if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0 && ConfigManager.shouldNotify(refreshValue)) {
                    player.func_146105_b(new TextComponentTranslation("lootr.message.refresh_in", new Object[]{refreshValue / 20}).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE).func_150227_a(Boolean.valueOf(true))), true);
                } else if (refreshValue == -1 && ConfigManager.isRefreshing(world, cart)) {
                    DataStorage.setRefreshing(tileId, ConfigManager.getRefreshValue());
                    player.func_146105_b(new TextComponentTranslation("lootr.message.refresh_start", new Object[]{ConfigManager.getRefreshValue() / 20}).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE).func_150227_a(Boolean.valueOf(true))), true);
                }
                SpecialChestInventory provider = DataStorage.getInventory(world, cart, (EntityPlayerMP)player, cart::addLoot, cart.func_180425_c());
                player.func_180468_a((IInteractionObject)provider);
            }
        }
    }

    public static boolean handleLootInventory(Block block, World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            return false;
        }
        if (player.func_175149_v()) {
            player.func_71053_j();
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof LootrInventoryTileEntity) {
            int refreshValue;
            UUID tileId = ((ILootTile)te).getTileId();
            LootrInventoryTileEntity tile = (LootrInventoryTileEntity)te;
            NonNullList<ItemStack> stacks = null;
            if (tile.getCustomInventory() != null) {
                stacks = ChestUtil.copyItemList(tile.getCustomInventory());
            }
            if (DataStorage.isDecayed(tileId)) {
                world.func_175655_b(pos, true);
                DataStorage.removeDecayed(tileId);
                player.func_146105_b(new TextComponentTranslation("lootr.message.decayed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150227_a(Boolean.valueOf(true))), true);
                return false;
            }
            int decayValue = DataStorage.getDecayValue(tileId);
            if (decayValue > 0 && ConfigManager.shouldNotify(decayValue)) {
                player.func_146105_b(new TextComponentTranslation("lootr.message.decay_in", new Object[]{decayValue / 20}).func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150227_a(Boolean.valueOf(true))), true);
            } else if (decayValue == -1 && ConfigManager.isDecaying(world, (ILootTile)te)) {
                DataStorage.setDecaying(tileId, ConfigManager.getDecayValue());
                player.func_146105_b(new TextComponentTranslation("lootr.message.decay_start", new Object[]{ConfigManager.getDecayValue() / 20}).func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150227_a(Boolean.valueOf(true))), true);
            }
            if (DataStorage.isRefreshed(tileId)) {
                DataStorage.refreshInventory(world, ((ILootTile)te).getTileId(), (EntityPlayerMP)player, pos);
                DataStorage.removeRefreshed(tileId);
                player.func_146105_b(new TextComponentTranslation("lootr.message.refreshed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE).func_150227_a(Boolean.valueOf(true))), true);
            }
            if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0 && ConfigManager.shouldNotify(refreshValue)) {
                player.func_146105_b(new TextComponentTranslation("lootr.message.refresh_in", new Object[]{refreshValue / 20}).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE).func_150227_a(Boolean.valueOf(true))), true);
            } else if (refreshValue == -1 && ConfigManager.isRefreshing(world, (ILootTile)te)) {
                DataStorage.setRefreshing(tileId, ConfigManager.getRefreshValue());
                player.func_146105_b(new TextComponentTranslation("lootr.message.refresh_start", new Object[]{ConfigManager.getRefreshValue() / 20}).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE).func_150227_a(Boolean.valueOf(true))), true);
            }
            SpecialChestInventory provider = DataStorage.getInventory(world, tile.getTileId(), stacks, (EntityPlayerMP)player, pos, (TileEntityLockableLoot)tile);
            player.func_71007_a((IInventory)provider);
            return true;
        }
        return false;
    }

    public static NonNullList<ItemStack> copyItemList(NonNullList<ItemStack> reference) {
        NonNullList contents = NonNullList.func_191197_a((int)reference.size(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < reference.size(); ++i) {
            contents.set(i, (Object)((ItemStack)reference.get(i)).func_77946_l());
        }
        return contents;
    }
}

