/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.setup;

import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.block.tile.LootrChestTileEntity;
import noobanidus.mods.lootr.block.tile.LootrInventoryTileEntity;
import noobanidus.mods.lootr.block.tile.LootrShulkerTileEntity;
import noobanidus.mods.lootr.block.tile.TrappedLootrChestTileEntity;
import noobanidus.mods.lootr.client.ClientGetter;
import noobanidus.mods.lootr.client.block.SpecialLootChestTileRenderer;
import noobanidus.mods.lootr.client.block.SpecialLootShulkerTileRenderer;
import noobanidus.mods.lootr.client.entity.LootrMinecartRenderer;
import noobanidus.mods.lootr.client.item.SpecialLootChestItemRenderer;
import noobanidus.mods.lootr.client.item.SpecialLootShulkerItemRenderer;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.init.ModItems;
import noobanidus.mods.lootr.setup.CommonSetup;

@Mod.EventBusSubscriber(modid="lootr", value={Side.CLIENT})
public class ClientSetup
extends CommonSetup {
    @Override
    public void preInit() {
        super.preInit();
        ClientRegistry.bindTileEntitySpecialRenderer(LootrChestTileEntity.class, new SpecialLootChestTileRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(LootrInventoryTileEntity.class, new SpecialLootChestTileRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TrappedLootrChestTileEntity.class, new SpecialLootChestTileRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(LootrShulkerTileEntity.class, (TileEntitySpecialRenderer)new SpecialLootShulkerTileRenderer());
        RenderingRegistry.registerEntityRenderingHandler(LootrChestMinecartEntity.class, LootrMinecartRenderer::new);
    }

    @Override
    public void init() {
        super.init();
        ModItems.CHEST.setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new SpecialLootChestItemRenderer());
        ModItems.TRAPPED_CHEST.setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new SpecialLootChestItemRenderer());
        ModItems.SHULKER.setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new SpecialLootShulkerItemRenderer());
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomStateMapper((Block)ModBlocks.CHEST, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockChest.field_176459_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.TRAPPED_CHEST, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockChest.field_176459_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.SHULKER, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockShulkerBox.field_190957_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)ModBlocks.INVENTORY, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockChest.field_176459_a}).func_178441_a());
        ModelLoader.setCustomModelResourceLocation((Item)ModItems.CHEST, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("lootr", "lootr_chest_item"), null));
        ModelLoader.setCustomModelResourceLocation((Item)ModItems.SHULKER, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("lootr", "lootr_shulker_item"), null));
        ModelLoader.setCustomModelResourceLocation((Item)ModItems.TRAPPED_CHEST, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("lootr", "lootr_trapped_chest_item"), null));
        ModelLoader.setCustomModelResourceLocation((Item)ModItems.TROPHY, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("lootr", "trophy_item"), null));
    }

    @Override
    public EntityPlayer getPlayer() {
        return ClientGetter.getPlayer();
    }

    @SubscribeEvent
    public static void stitch(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(new ResourceLocation("lootr", "shulker"));
        event.getMap().func_174942_a(new ResourceLocation("lootr", "chest"));
        event.getMap().func_174942_a(new ResourceLocation("lootr", "shulker_opened"));
        event.getMap().func_174942_a(new ResourceLocation("lootr", "chest_opened"));
    }

    @Override
    public void changeCartStatus(int entityId, boolean status) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                Lootr.LOG.info("Unable to mark entity with id '" + entityId + "' as opened as world is null.");
                return;
            }
            Entity cart = world.func_73045_a(entityId);
            if (cart == null) {
                Lootr.LOG.info("Unable to mark entity with id '" + entityId + "' as opened as entity is null.");
                return;
            }
            if (!(cart instanceof LootrChestMinecartEntity)) {
                Lootr.LOG.info("Unable to mark entity with id '" + entityId + "' as opened as entity is not a Lootr minecart.");
                return;
            }
            if (status) {
                ((LootrChestMinecartEntity)cart).setOpened();
            } else {
                ((LootrChestMinecartEntity)cart).setClosed();
            }
        });
    }
}

