/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.event;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.block.tile.LootrInventoryTileEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.init.ModBlocks;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="lootr")
public class HandleWorldGen {
    private static LinkedList<Pair<WeakReference<World>, ChunkPos>> generatedChunks = new LinkedList();
    private static boolean stopItemSpawning = false;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGenerate(PopulateChunkEvent.Post event) {
        if (ConfigManager.CONVERT_WORLDGEN_INVENTORIES) {
            generatedChunks.add((Pair<WeakReference<World>, ChunkPos>)Pair.of(new WeakReference<World>(event.getWorld()), (Object)new ChunkPos(event.getChunkX(), event.getChunkZ())));
        }
    }

    @SubscribeEvent
    public static void onItemJoin(EntityJoinWorldEvent event) {
        if (stopItemSpawning && event.getEntity() instanceof EntityItem) {
            event.setCanceled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TileEntity replaceOldLootBlockAt(Chunk chunk, BlockPos worldPos, IBlockState newState) {
        World world = chunk.func_177412_p();
        stopItemSpawning = true;
        try {
            world.func_180501_a(worldPos, newState, 2);
            world.func_175713_t(worldPos);
            TileEntity tileEntity = chunk.func_177424_a(worldPos, Chunk.EnumCreateEntityType.IMMEDIATE);
            return tileEntity;
        }
        catch (RuntimeException e) {
            Lootr.LOG.error("Couldn't replace loot block", (Throwable)e);
            TileEntity tileEntity = null;
            return tileEntity;
        }
        finally {
            stopItemSpawning = false;
        }
    }

    private static void processChunkForWorldgen(Chunk chunk) {
        ArrayList tileEntities = new ArrayList(chunk.func_177434_r().values());
        for (TileEntity te : tileEntities) {
            IBlockState replacement;
            if (!(te instanceof TileEntityLockableLoot) || te instanceof ILootTile) continue;
            TileEntityLockableLoot teLockable = (TileEntityLockableLoot)te;
            if (teLockable.field_184284_m != null) continue;
            NonNullList newInventory = NonNullList.func_191196_a();
            int size = teLockable.func_70302_i_();
            for (int slot = 0; slot < size; ++slot) {
                ItemStack stack = teLockable.func_70301_a(slot);
                if (!stack.func_190926_b() || size <= 27) {
                    newInventory.add((Object)stack.func_77946_l());
                }
                teLockable.func_70299_a(slot, ItemStack.field_190927_a);
            }
            if (newInventory.size() <= 0) continue;
            BlockPos pos = te.func_174877_v();
            teLockable.func_174888_l();
            IBlockState currentBlockState = chunk.func_177435_g(pos);
            EnumFacing newFacing = EnumFacing.SOUTH;
            if (currentBlockState.func_177227_a().contains(BlockChest.field_176459_a)) {
                newFacing = (EnumFacing)currentBlockState.func_177229_b((IProperty)BlockChest.field_176459_a);
            }
            if ((te = HandleWorldGen.replaceOldLootBlockAt(chunk, pos, replacement = ModBlocks.INVENTORY.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)newFacing))) instanceof LootrInventoryTileEntity) {
                LootrInventoryTileEntity inventory = (LootrInventoryTileEntity)te;
                inventory.setCustomInventory((NonNullList<ItemStack>)newInventory);
                inventory.func_70296_d();
                continue;
            }
            Lootr.LOG.error("replacement TE " + te + " is not an LootrInventoryTileEntity dim " + chunk.func_177412_p().field_73011_w.getDimension() + " at " + pos);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (ConfigManager.CONVERT_WORLDGEN_INVENTORIES && event.phase == TickEvent.Phase.END && generatedChunks.size() > 0) {
            ArrayList processing = new ArrayList();
            generatedChunks.removeIf(pair -> {
                World world = (World)((WeakReference)pair.getLeft()).get();
                if (world == null) {
                    return true;
                }
                Chunk chunk = world.func_72863_F().func_186026_b(((ChunkPos)pair.getRight()).field_77276_a, ((ChunkPos)pair.getRight()).field_77275_b);
                if (chunk == null) {
                    return false;
                }
                processing.add(chunk);
                return true;
            });
            for (Chunk chunk : processing) {
                HandleWorldGen.processChunkForWorldgen(chunk);
            }
        }
    }
}

