/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import noobanidus.mods.lootr.api.LootFiller;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.compat.CompatHelper;
import noobanidus.mods.lootr.compat.RecurrentComplexCompat;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;

public class ChestData
extends WorldSavedData {
    private BlockPos pos;
    private Integer dimension;
    private UUID entityId;
    private UUID tileId;
    private UUID customId;
    private Map<UUID, SpecialChestInventory> inventories = new HashMap<UUID, SpecialChestInventory>();
    private NonNullList<ItemStack> reference;
    private boolean custom;

    public UUID getEntityId() {
        return this.entityId;
    }

    public static String ID(UUID id) {
        String idString = id.toString();
        return "lootr/" + idString.charAt(0) + "/" + idString.substring(0, 2) + "/" + idString;
    }

    public ChestData(String ID) {
        super(ID);
    }

    public ChestData(int dimension, UUID id, @Nullable UUID customId, @Nullable NonNullList<ItemStack> base) {
        super(ChestData.ID(id));
        this.pos = null;
        this.dimension = dimension;
        this.entityId = null;
        this.tileId = id;
        this.reference = base;
        this.custom = true;
        this.customId = customId;
        if (customId == null && base == null) {
            throw new IllegalArgumentException("Both customId and inventory reference cannot be null.");
        }
    }

    public ChestData(int dimension, UUID id) {
        super(ChestData.ID(id));
        this.pos = null;
        this.dimension = dimension;
        this.entityId = null;
        this.tileId = id;
        this.reference = null;
        this.custom = false;
        this.customId = null;
    }

    public ChestData(UUID entityId) {
        super(ChestData.ID(entityId));
        this.pos = null;
        this.dimension = null;
        this.tileId = null;
        this.entityId = entityId;
        this.reference = null;
        this.custom = false;
        this.customId = null;
    }

    public LootFiller customInventory() {
        return (player, inventory, table, seed) -> {
            for (int i = 0; i < this.reference.size(); ++i) {
                inventory.func_70299_a(i, ((ItemStack)this.reference.get(i)).func_77946_l());
            }
        };
    }

    public Map<UUID, SpecialChestInventory> getInventories() {
        return this.inventories;
    }

    public void setInventories(Map<UUID, SpecialChestInventory> inventories) {
        this.inventories = inventories;
    }

    public boolean clearInventory(UUID uuid) {
        return this.inventories.remove(uuid) != null;
    }

    @Nullable
    public SpecialChestInventory getInventory(EntityPlayerMP player) {
        return this.inventories.get(player.func_110124_au());
    }

    public SpecialChestInventory createInventory(EntityPlayerMP player, LootFiller filler, @Nullable TileEntityLockableLoot tile) {
        SpecialChestInventory result;
        WorldServer world = (WorldServer)player.field_70170_p;
        LootrChestMinecartEntity cart = null;
        long seed = -1L;
        ResourceLocation lootTable = null;
        if (this.entityId != null) {
            Entity initial = world.func_175733_a(this.entityId);
            if (!(initial instanceof LootrChestMinecartEntity)) {
                return null;
            }
            cart = (LootrChestMinecartEntity)initial;
            NonNullList items = NonNullList.func_191197_a((int)cart.func_70302_i_(), (Object)ItemStack.field_190927_a);
            result = new SpecialChestInventory(this, (NonNullList<ItemStack>)items, cart.func_145748_c_(), this.pos);
            lootTable = cart.field_184290_c;
        } else {
            if (tile == null) {
                return null;
            }
            lootTable = ((ILootTile)tile).getTable();
            NonNullList items = NonNullList.func_191197_a((int)tile.func_70302_i_(), (Object)ItemStack.field_190927_a);
            result = new SpecialChestInventory(this, (NonNullList<ItemStack>)items, tile.func_145748_c_(), this.pos);
        }
        filler.fillWithLoot((EntityPlayer)player, result, lootTable, seed);
        if (CompatHelper.isRecComplexLoaded()) {
            long theSeed = ConfigManager.RANDOMISE_SEED ? ThreadLocalRandom.current().nextLong() : (seed == Long.MIN_VALUE ? 0L : seed);
            RecurrentComplexCompat.checkInventory(world, result, theSeed == 0L ? new Random() : new Random(theSeed));
        }
        this.inventories.put(player.func_110124_au(), result);
        this.func_76186_a(true);
        world.getPerWorldStorage().func_75744_a();
        result.setBlockPos(this.pos);
        return result;
    }

    public void func_76184_a(NBTTagCompound compound) {
        this.inventories.clear();
        this.pos = null;
        this.dimension = null;
        this.entityId = null;
        this.tileId = null;
        if (compound.func_74764_b("position")) {
            this.pos = BlockPos.func_177969_a((long)compound.func_74763_f("position"));
        }
        if (compound.func_74764_b("dimension")) {
            this.dimension = compound.func_74762_e("dimension");
        }
        if (compound.func_186855_b("entityId")) {
            this.entityId = compound.func_186857_a("entityId");
        }
        if (compound.func_186855_b("tileId")) {
            this.tileId = compound.func_186857_a("tileId");
        }
        if (compound.func_74764_b("custom")) {
            this.custom = compound.func_74767_n("custom");
        }
        if (compound.func_186855_b("customId")) {
            this.customId = compound.func_186857_a("customId");
        }
        if (compound.func_74764_b("reference") && compound.func_74764_b("referenceSize")) {
            int size = compound.func_74762_e("referenceSize");
            this.reference = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)compound.func_74775_l("reference"), this.reference);
        }
        NBTTagList compounds = compound.func_150295_c("inventories", 10);
        for (int i = 0; i < compounds.func_74745_c(); ++i) {
            NBTTagCompound thisTag = compounds.func_150305_b(i);
            NBTTagCompound items = thisTag.func_74775_l("chest");
            String name = thisTag.func_74779_i("name");
            UUID uuid = thisTag.func_186857_a("uuid");
            this.inventories.put(uuid, new SpecialChestInventory(this, items, name, this.pos));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        if (this.pos != null) {
            compound.func_74772_a("position", this.pos.func_177986_g());
        }
        if (this.dimension != null) {
            compound.func_74768_a("dimension", this.dimension.intValue());
        }
        if (this.entityId != null) {
            compound.func_186854_a("entityId", this.entityId);
        }
        if (this.tileId != null) {
            compound.func_186854_a("tileId", this.tileId);
        }
        if (this.customId != null) {
            compound.func_186854_a("customId", this.customId);
        }
        compound.func_74757_a("custom", this.custom);
        if (this.reference != null) {
            compound.func_74768_a("referenceSize", this.reference.size());
            compound.func_74782_a("reference", (NBTBase)ItemStackHelper.func_191281_a((NBTTagCompound)new NBTTagCompound(), this.reference, (boolean)true));
        }
        NBTTagList compounds = new NBTTagList();
        for (Map.Entry<UUID, SpecialChestInventory> entry : this.inventories.entrySet()) {
            NBTTagCompound thisTag = new NBTTagCompound();
            thisTag.func_186854_a("uuid", entry.getKey());
            thisTag.func_74782_a("chest", (NBTBase)entry.getValue().writeItems());
            thisTag.func_74778_a("name", entry.getValue().writeName());
            compounds.func_74742_a((NBTBase)thisTag);
        }
        compound.func_74782_a("inventories", (NBTBase)compounds);
        return compound;
    }

    public void clear() {
        this.inventories.clear();
    }

    public static ChestData unwrap(ChestData data, int dimension, BlockPos position) {
        data.pos = position;
        data.dimension = dimension;
        return data;
    }
}

