/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.INBTSerializable;

public class AdvancementData
extends WorldSavedData {
    private final Set<UUIDPair> data = new HashSet<UUIDPair>();

    public AdvancementData(String id) {
        super(id);
    }

    public boolean contains(UUID first, UUID second) {
        return this.contains(new UUIDPair(first, second));
    }

    public boolean contains(UUIDPair pair) {
        return this.data.contains(pair);
    }

    public void add(UUID first, UUID second) {
        this.add(new UUIDPair(first, second));
    }

    public void add(UUIDPair pair) {
        this.data.add(pair);
    }

    public void func_76184_a(NBTTagCompound compound) {
        this.data.clear();
        NBTTagList data = compound.func_150295_c("data", 10);
        for (int i = 0; i < data.func_74745_c(); ++i) {
            this.data.add(UUIDPair.fromNBT(data.func_150305_b(i)));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound pCompound) {
        NBTTagList result = new NBTTagList();
        for (UUIDPair pair : this.data) {
            result.func_74742_a((NBTBase)pair.serializeNBT());
        }
        pCompound.func_74782_a("data", (NBTBase)result);
        return pCompound;
    }

    public static class UUIDPair
    implements INBTSerializable<NBTTagCompound> {
        private UUID first;
        private UUID second;

        protected UUIDPair() {
        }

        public UUIDPair(@Nonnull UUID first, @Nonnull UUID second) {
            this.first = first;
            this.second = second;
        }

        @Nonnull
        public UUID getFirst() {
            return this.first;
        }

        @Nonnull
        public UUID getSecond() {
            return this.second;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UUIDPair uuidPair = (UUIDPair)o;
            if (!this.first.equals(uuidPair.first)) {
                return false;
            }
            return this.second.equals(uuidPair.second);
        }

        public int hashCode() {
            int result = this.first.hashCode();
            result = 31 * result + this.second.hashCode();
            return result;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound result = new NBTTagCompound();
            result.func_186854_a("first", this.getFirst());
            result.func_186854_a("second", this.getSecond());
            return result;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.first = nbt.func_186857_a("first");
            this.second = nbt.func_186857_a("second");
        }

        public static UUIDPair fromNBT(NBTTagCompound tag) {
            UUIDPair pair = new UUIDPair();
            pair.deserializeNBT(tag);
            return pair;
        }
    }
}

