/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.client.block;

import java.util.UUID;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelShulker;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderShulker;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import noobanidus.mods.lootr.block.tile.LootrShulkerTileEntity;
import noobanidus.mods.lootr.config.ConfigManager;

public class SpecialLootShulkerTileRenderer
extends TileEntitySpecialRenderer<LootrShulkerTileEntity> {
    public static final ResourceLocation MATERIAL = new ResourceLocation("lootr", "textures/shulker.png");
    public static final ResourceLocation MATERIAL2 = new ResourceLocation("lootr", "textures/shulker_opened.png");
    private final ModelShulker model = new ModelShulker();
    private UUID playerId = null;

    protected ResourceLocation getMaterial(LootrShulkerTileEntity tile) {
        if (ConfigManager.isVanillaTextures()) {
            return RenderShulker.field_188342_a[tile.getColor().func_176765_a()];
        }
        if (this.playerId == null) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g == null) {
                return MATERIAL;
            }
            this.playerId = mc.field_71439_g.func_110124_au();
        }
        if (tile.isOpened()) {
            return MATERIAL2;
        }
        if (tile.getOpeners().contains(this.playerId)) {
            return MATERIAL2;
        }
        return MATERIAL;
    }

    public void render(LootrShulkerTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState iblockstate;
        EnumFacing enumfacing = EnumFacing.UP;
        if (te.func_145830_o() && (iblockstate = this.func_178459_a().func_180495_p(te.func_174877_v())).func_177230_c() instanceof BlockShulkerBox) {
            enumfacing = (EnumFacing)iblockstate.func_177229_b((IProperty)BlockShulkerBox.field_190957_a);
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179129_p();
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            this.func_147499_a(this.getMaterial(te));
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        if (destroyStage < 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        float f = 0.9995f;
        GlStateManager.func_179152_a((float)0.9995f, (float)0.9995f, (float)0.9995f);
        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
        switch (enumfacing) {
            case DOWN: {
                GlStateManager.func_179109_b((float)0.0f, (float)2.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            default: {
                break;
            }
            case NORTH: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179109_b((float)-1.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179109_b((float)1.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        this.model.field_187067_b.func_78785_a(0.0625f);
        GlStateManager.func_179109_b((float)0.0f, (float)(-te.getProgress(partialTicks) * 0.5f), (float)0.0f);
        GlStateManager.func_179114_b((float)(270.0f * te.getProgress(partialTicks)), (float)0.0f, (float)1.0f, (float)0.0f);
        this.model.field_187068_c.func_78785_a(0.0625f);
        GlStateManager.func_179089_o();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
    }
}

