/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.block.tile;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerShulkerBox;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.config.ConfigManager;
import org.jetbrains.annotations.Nullable;

public class LootrShulkerTileEntity
extends TileEntityLockableLoot
implements ILootTile,
ITickable {
    public Set<UUID> openers = new HashSet<UUID>();
    private final NonNullList<ItemStack> itemStacks = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private int openCount;
    private TileEntityShulkerBox.AnimationStatus animationStatus = TileEntityShulkerBox.AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;
    private ResourceLocation savedLootTable = null;
    private long seed = -1L;
    private UUID tileId = null;
    private boolean opened;

    public void func_73660_a() {
        this.updateAnimation();
        if (this.animationStatus == TileEntityShulkerBox.AnimationStatus.OPENING || this.animationStatus == TileEntityShulkerBox.AnimationStatus.CLOSING) {
            this.moveCollidedEntities();
        }
    }

    protected void updateAnimation() {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case CLOSED: {
                this.progress = 0.0f;
                break;
            }
            case OPENING: {
                this.progress += 0.1f;
                if (!(this.progress >= 1.0f)) break;
                this.moveCollidedEntities();
                this.animationStatus = TileEntityShulkerBox.AnimationStatus.OPENED;
                this.progress = 1.0f;
                break;
            }
            case CLOSING: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = TileEntityShulkerBox.AnimationStatus.CLOSED;
                this.progress = 0.0f;
                break;
            }
            case OPENED: {
                this.progress = 1.0f;
            }
        }
    }

    public TileEntityShulkerBox.AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public AxisAlignedBB getBoundingBox(IBlockState p_190584_1_) {
        return this.getBoundingBox((EnumFacing)p_190584_1_.func_177229_b((IProperty)BlockShulkerBox.field_190957_a));
    }

    public AxisAlignedBB getBoundingBox(EnumFacing p_190587_1_) {
        return Block.field_185505_j.func_72321_a((double)(0.5f * this.getProgress(1.0f) * (float)p_190587_1_.func_82601_c()), (double)(0.5f * this.getProgress(1.0f) * (float)p_190587_1_.func_96559_d()), (double)(0.5f * this.getProgress(1.0f) * (float)p_190587_1_.func_82599_e()));
    }

    private AxisAlignedBB getTopBoundingBox(EnumFacing p_190588_1_) {
        EnumFacing enumfacing = p_190588_1_.func_176734_d();
        return this.getBoundingBox(p_190588_1_).func_191195_a((double)enumfacing.func_82601_c(), (double)enumfacing.func_96559_d(), (double)enumfacing.func_82599_e());
    }

    private void moveCollidedEntities() {
        EnumFacing enumfacing;
        AxisAlignedBB axisalignedbb;
        List list;
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (iblockstate.func_177230_c() instanceof BlockShulkerBox && !(list = this.field_145850_b.func_72839_b((Entity)null, axisalignedbb = this.getTopBoundingBox(enumfacing = (EnumFacing)iblockstate.func_177229_b((IProperty)BlockShulkerBox.field_190957_a)).func_186670_a(this.field_174879_c))).isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity.func_184192_z() == EnumPushReaction.IGNORE) continue;
                double d0 = 0.0;
                double d1 = 0.0;
                double d2 = 0.0;
                AxisAlignedBB axisalignedbb1 = entity.func_174813_aQ();
                switch (enumfacing.func_176740_k()) {
                    case X: {
                        d0 = enumfacing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? axisalignedbb.field_72336_d - axisalignedbb1.field_72340_a : axisalignedbb1.field_72336_d - axisalignedbb.field_72340_a;
                        d0 += 0.01;
                        break;
                    }
                    case Y: {
                        d1 = enumfacing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? axisalignedbb.field_72337_e - axisalignedbb1.field_72338_b : axisalignedbb1.field_72337_e - axisalignedbb.field_72338_b;
                        d1 += 0.01;
                        break;
                    }
                    case Z: {
                        d2 = enumfacing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? axisalignedbb.field_72334_f - axisalignedbb1.field_72339_c : axisalignedbb1.field_72334_f - axisalignedbb.field_72339_c;
                        d2 += 0.01;
                    }
                }
                entity.func_70091_d(MoverType.SHULKER_BOX, d0 * (double)enumfacing.func_82601_c(), d1 * (double)enumfacing.func_96559_d(), d2 * (double)enumfacing.func_82599_e());
            }
        }
    }

    public int func_70302_i_() {
        return 27;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.openCount = type;
            if (type == 0) {
                this.animationStatus = TileEntityShulkerBox.AnimationStatus.CLOSING;
            }
            if (type == 1) {
                this.animationStatus = TileEntityShulkerBox.AnimationStatus.OPENING;
            }
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(EntityPlayer pPlayer) {
        if (!pPlayer.func_175149_v()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.openCount);
            if (this.openCount == 1) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_191262_fB, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public void func_174886_c(EntityPlayer pPlayer) {
        if (!pPlayer.func_175149_v()) {
            --this.openCount;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_191261_fA, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            this.openers.add(pPlayer.func_110124_au());
            this.updatePacketViaState();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.field_190577_o : "container.shulkerBox";
    }

    public String func_174875_k() {
        return "minecraft:shulker_box";
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_150297_b("specialLootChest_table", 8)) {
            this.savedLootTable = new ResourceLocation(compound.func_74779_i("specialLootChest_table"));
        }
        if (compound.func_150297_b("specialLootChest_seed", 4)) {
            this.seed = compound.func_74763_f("specialLootChest_seed");
        }
        if (this.savedLootTable == null && compound.func_150297_b("LootTable", 8)) {
            this.savedLootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            if (compound.func_150297_b("LootTableSeed", 4)) {
                this.seed = compound.func_74763_f("LootTableSeed");
            }
            this.func_189404_a(this.savedLootTable, this.seed);
        }
        if (compound.func_186855_b("tileId")) {
            this.tileId = compound.func_186857_a("tileId");
        } else if (this.tileId == null) {
            this.getTileId();
        }
        if (compound.func_74764_b("LootrOpeners")) {
            NBTTagList openers = compound.func_150295_c("LootrOpeners", 10);
            this.openers.clear();
            for (NBTBase item : openers) {
                this.openers.add(NBTUtil.func_186860_b((NBTTagCompound)((NBTTagCompound)item)));
            }
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        if (this.savedLootTable != null) {
            compound.func_74778_a("specialLootBarrel_table", this.savedLootTable.toString());
            compound.func_74778_a("LootTable", this.savedLootTable.toString());
        }
        if (this.seed != -1L) {
            compound.func_74772_a("specialLootBarrel_seed", this.seed);
            compound.func_74772_a("LootTableSeed", this.seed);
        }
        compound.func_186854_a("tileId", this.getTileId());
        NBTTagList list = new NBTTagList();
        for (UUID opener : this.openers) {
            list.func_74742_a((NBTBase)NBTUtil.func_186862_a((UUID)opener));
        }
        compound.func_74782_a("LootrOpeners", (NBTBase)list);
        return compound;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing side) {
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return false;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.itemStacks;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.itemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public float getProgress(float pPartialTicks) {
        return this.progressOld + (this.progress - this.progressOld) * pPartialTicks;
    }

    public void func_189404_a(ResourceLocation lootTableIn, long seedIn) {
        this.savedLootTable = lootTableIn;
        this.seed = seedIn;
        super.func_189404_a(lootTableIn, seedIn);
    }

    @javax.annotation.Nullable
    @SideOnly(value=Side.CLIENT)
    public EnumDyeColor getColor() {
        return EnumDyeColor.YELLOW;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerShulkerBox(playerInventory, (IInventory)this, playerIn);
    }

    public boolean isClosed() {
        return this.animationStatus == TileEntityShulkerBox.AnimationStatus.CLOSED;
    }

    public void func_184281_d(@javax.annotation.Nullable EntityPlayer player) {
    }

    @Override
    public void fillWithLoot(EntityPlayer player, IInventory inventory, @javax.annotation.Nullable ResourceLocation overrideTable, long seed) {
        if (this.field_145850_b != null && this.savedLootTable != null && this.field_145850_b.func_73046_m() != null) {
            BlockPos worldPosition = this.func_174877_v();
            LootTable loottable = this.field_145850_b.func_184146_ak().func_186521_a(overrideTable != null ? overrideTable : this.savedLootTable);
            if (loottable == LootTable.field_186464_a) {
                Lootr.LOG.error("Unable to fill loot chest in " + this.field_145850_b + " at " + worldPosition + " as the loot table '" + (overrideTable != null ? overrideTable : this.savedLootTable) + "' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.");
            }
            if (player instanceof EntityPlayerMP) {
                // empty if block
            }
            long theSeed = ConfigManager.RANDOMISE_SEED ? ThreadLocalRandom.current().nextLong() : (seed == Long.MIN_VALUE ? this.seed : seed);
            LootContext.Builder builder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
            }
            Random random = theSeed == 0L ? new Random() : new Random(theSeed);
            loottable.func_186460_a(inventory, random, builder.func_186471_a());
        }
    }

    @Override
    public ResourceLocation getTable() {
        return this.savedLootTable;
    }

    @Override
    public Set<UUID> getOpeners() {
        return this.openers;
    }

    @Override
    public UUID getTileId() {
        if (this.tileId == null) {
            this.tileId = UUID.randomUUID();
        }
        return this.tileId;
    }

    @Override
    public void updatePacketViaState() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 8);
        }
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @javax.annotation.Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 10, this.func_189517_E_());
    }

    public void onDataPacket(@Nonnull NetworkManager net, @Nonnull SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
    }
}

