/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.block.tile;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import org.jetbrains.annotations.Nullable;

public class LootrChestTileEntity
extends TileEntityChest
implements ILootTile,
ITickable {
    public Set<UUID> openers = new HashSet<UUID>();
    private int ticksSinceSync;
    private int specialNumPlayersUsingChest;
    private ResourceLocation savedLootTable = null;
    private long seed = -1L;
    private UUID tileId;
    private boolean opened;

    @Override
    public UUID getTileId() {
        if (this.tileId == null) {
            this.tileId = UUID.randomUUID();
        }
        return this.tileId;
    }

    public void func_189404_a(ResourceLocation lootTableIn, long seedIn) {
        super.func_189404_a(lootTableIn, seedIn);
        this.savedLootTable = lootTableIn;
        this.seed = seedIn;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
    }

    public void func_184281_d(@javax.annotation.Nullable EntityPlayer player) {
    }

    @Override
    public void fillWithLoot(EntityPlayer player, IInventory inventory, @javax.annotation.Nullable ResourceLocation overrideTable, long seed) {
        if (this.field_145850_b != null && this.savedLootTable != null && this.field_145850_b.func_73046_m() != null) {
            BlockPos worldPosition = this.func_174877_v();
            LootTable loottable = this.field_145850_b.func_184146_ak().func_186521_a(overrideTable != null ? overrideTable : this.savedLootTable);
            if (loottable == LootTable.field_186464_a) {
                Lootr.LOG.error("Unable to fill loot chest in " + this.field_145850_b + " at " + worldPosition + " as the loot table '" + (overrideTable != null ? overrideTable : this.savedLootTable) + "' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.");
            }
            if (player instanceof EntityPlayerMP) {
                // empty if block
            }
            long theSeed = ConfigManager.RANDOMISE_SEED ? ThreadLocalRandom.current().nextLong() : (seed == Long.MIN_VALUE ? this.seed : seed);
            LootContext.Builder builder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
            }
            Random random = theSeed == 0L ? new Random() : new Random(theSeed);
            loottable.func_186460_a(inventory, random, builder.func_186471_a());
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_150297_b("specialLootChest_table", 8)) {
            this.savedLootTable = new ResourceLocation(compound.func_74779_i("specialLootChest_table"));
        }
        if (compound.func_150297_b("specialLootChest_seed", 4)) {
            this.seed = compound.func_74763_f("specialLootChest_seed");
        }
        if (this.savedLootTable == null && compound.func_150297_b("LootTable", 8)) {
            this.savedLootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            if (this.seed == 0L && compound.func_150297_b("LootTableSeed", 4)) {
                this.seed = compound.func_74763_f("LootTableSeed");
            }
        }
        if (compound.func_186855_b("tileId")) {
            this.tileId = compound.func_186857_a("tileId");
        }
        if (compound.func_74764_b("LootrOpeners")) {
            NBTTagList openers = compound.func_150295_c("LootrOpeners", 10);
            this.openers.clear();
            for (NBTBase item : openers) {
                this.openers.add(NBTUtil.func_186860_b((NBTTagCompound)((NBTTagCompound)item)));
            }
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        if (this.savedLootTable != null) {
            compound.func_74778_a("specialLootChest_table", this.savedLootTable.toString());
            compound.func_74778_a("LootTable", this.savedLootTable.toString());
        }
        if (this.seed != -1L) {
            compound.func_74772_a("specialLootChest_seed", this.seed);
            compound.func_74772_a("LootTableSeed", this.seed);
        }
        if (this.tileId != null) {
            compound.func_186854_a("tileId", this.tileId);
        }
        NBTTagList list = new NBTTagList();
        for (UUID opener : this.openers) {
            list.func_74742_a((NBTBase)NBTUtil.func_186862_a((UUID)opener));
        }
        compound.func_74782_a("LootrOpeners", (NBTBase)list);
        return compound;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing side) {
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return false;
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        this.specialNumPlayersUsingChest = LootrChestTileEntity.calculatePlayersUsingSync(this.field_145850_b, (TileEntityLockableLoot)this, this.ticksSinceSync, i, j, k, this.specialNumPlayersUsingChest);
        this.field_145986_n = this.field_145989_m;
        if (this.specialNumPlayersUsingChest > 0 && this.field_145989_m == 0.0f) {
            this.playSound(SoundEvents.field_187657_V);
        }
        if (this.specialNumPlayersUsingChest == 0 && this.field_145989_m > 0.0f || this.specialNumPlayersUsingChest > 0 && this.field_145989_m < 1.0f) {
            float f1 = this.field_145989_m;
            this.field_145989_m = this.specialNumPlayersUsingChest > 0 ? (this.field_145989_m += 0.1f) : (this.field_145989_m -= 0.1f);
            if (this.field_145989_m > 1.0f) {
                this.field_145989_m = 1.0f;
            }
            if (this.field_145989_m < 0.5f && f1 >= 0.5f) {
                this.playSound(SoundEvents.field_187651_T);
            }
            if (this.field_145989_m < 0.0f) {
                this.field_145989_m = 0.0f;
            }
        }
    }

    @Override
    public ResourceLocation getTable() {
        return this.savedLootTable;
    }

    @Override
    public Set<UUID> getOpeners() {
        return this.openers;
    }

    private void playSound(SoundEvent soundIn) {
        this.field_145850_b.func_184133_a(null, this.func_174877_v(), soundIn, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public static int calculatePlayersUsingSync(World world, TileEntityLockableLoot tile, int ticksSinceSync, int x, int y, int z, int numPlayersUsing) {
        if (!world.field_72995_K && numPlayersUsing != 0 && (ticksSinceSync + x + y + z) % 200 == 0) {
            numPlayersUsing = LootrChestTileEntity.calculatePlayersUsing(world, tile, x, y, z);
        }
        return numPlayersUsing;
    }

    public static int calculatePlayersUsing(World world, TileEntityLockableLoot tile, int x, int y, int z) {
        if (tile == null) {
            return 0;
        }
        int i = 0;
        for (EntityPlayer playerentity : world.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)x - 5.0, (double)y - 5.0, (double)z - 5.0, (double)(x + 1) + 5.0, (double)(y + 1) + 5.0, (double)(z + 1) + 5.0))) {
            IInventory inv;
            if (!(playerentity.field_71070_bA instanceof ContainerChest) || (inv = ((ContainerChest)playerentity.field_71070_bA).func_85151_d()) == null || inv != tile && (!(inv instanceof SpecialChestInventory) || !tile.func_174877_v().equals((Object)((SpecialChestInventory)inv).getPos()))) continue;
            ++i;
        }
        return i;
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.specialNumPlayersUsingChest < 0) {
                this.specialNumPlayersUsingChest = 0;
            }
            ++this.specialNumPlayersUsingChest;
            this.signalOpenCount();
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v()) {
            --this.specialNumPlayersUsingChest;
            this.signalOpenCount();
            this.openers.add(player.func_110124_au());
            this.func_70296_d();
            this.updatePacketViaState();
        }
    }

    @Override
    public void updatePacketViaState() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 8);
        }
    }

    protected void signalOpenCount() {
        if (this.func_145838_q() instanceof BlockChest) {
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.specialNumPlayersUsingChest);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.specialNumPlayersUsingChest = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @javax.annotation.Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(@Nonnull NetworkManager net, @Nonnull SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145979_i() {
        if (!this.field_145984_a) {
            this.field_145984_a = true;
            this.field_145991_k = null;
            this.field_145990_j = null;
            this.field_145992_i = null;
            this.field_145988_l = null;
        }
    }

    public static int getPlayersUsing(IBlockAccess reader, BlockPos posIn) {
        TileEntity tileentity;
        IBlockState blockstate = reader.func_180495_p(posIn);
        if (blockstate.func_177230_c().hasTileEntity(blockstate) && (tileentity = reader.func_175625_s(posIn)) instanceof LootrChestTileEntity) {
            return ((LootrChestTileEntity)tileentity).specialNumPlayersUsingChest;
        }
        return 0;
    }
}

