/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.block.tile.LootrChestTileEntity;
import noobanidus.mods.lootr.block.tile.LootrInventoryTileEntity;
import noobanidus.mods.lootr.block.tile.TrappedLootrChestTileEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.util.ChestUtil;
import org.jetbrains.annotations.Nullable;

public class LootrChestBlock
extends BlockChest {
    private final boolean isInventory;

    public LootrChestBlock(BlockChest.Type type, boolean isInventory) {
        super(type);
        this.isInventory = isInventory;
        this.func_149672_a(SoundType.field_185848_a);
        if (isInventory) {
            this.func_149663_c("lootr_inventory");
        } else if (type == ModBlocks.TYPE_LOOTR_TRAP) {
            this.func_149663_c("lootr_trapped_chest");
        } else {
            this.func_149663_c("lootr_chest");
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            ChestUtil.handleLootSneak((Block)this, world, pos, player);
        } else if (!this.func_176457_m(world, pos)) {
            if (this.isInventory) {
                ChestUtil.handleLootInventory((Block)this, world, pos, player);
            } else {
                ChestUtil.handleLootChest((Block)this, world, pos, player);
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (this.isInventory) {
            return new LootrInventoryTileEntity();
        }
        if (this.field_149956_a == ModBlocks.TYPE_LOOTR_TRAP) {
            return new TrappedLootrChestTileEntity();
        }
        return new LootrChestTileEntity();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185561_f;
    }

    public IBlockState func_176455_e(World world, BlockPos pos, IBlockState state) {
        return state;
    }

    public boolean func_149744_f(IBlockState state) {
        return this.field_149956_a == ModBlocks.TYPE_LOOTR_TRAP;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!blockState.func_185897_m()) {
            return 0;
        }
        return MathHelper.func_76125_a((int)LootrChestTileEntity.getPlayersUsing(blockAccess, pos), (int)0, (int)15);
    }

    public CreativeTabs func_149708_J() {
        return Lootr.TAB;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)(this.field_149956_a == ModBlocks.TYPE_LOOTR_TRAP ? Blocks.field_150447_bR : Blocks.field_150486_ae));
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (ConfigManager.BLAST_IMMUNE) {
            return Float.MAX_VALUE;
        }
        if (ConfigManager.BLAST_RESISTANT) {
            return 16.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        if (ConfigManager.ZERO_COMPARATOR) {
            return 0;
        }
        return 1;
    }
}

