/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.item.tool;

import WayofTime.bloodmagic.client.IMeshProvider;
import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.iface.IActivatable;
import WayofTime.bloodmagic.iface.IBindable;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import arcaratus.bloodarsenal.BloodArsenal;
import arcaratus.bloodarsenal.ConfigHandler;
import arcaratus.bloodarsenal.client.mesh.CustomMeshDefinitionActivatable;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBoundShears
extends ItemShears
implements IBindable,
IActivatable,
IMeshProvider {
    public static final Set<Block> EFFECTIVE_BLOCKS = Sets.newHashSet((Object[])new Block[]{Blocks.field_150321_G, Blocks.field_150329_H, Blocks.field_150395_bd, Blocks.field_150473_bD, Blocks.field_150325_L});

    public ItemBoundShears(String name) {
        this.func_77655_b("bloodarsenal.bound.shears");
        this.setRegistryName(name);
        this.func_77637_a(BloodArsenal.TAB_BLOOD_ARSENAL);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (I18n.func_188566_a((String)"tooltip.bloodarsenal.bound.shears.desc")) {
            tooltip.add(TextHelper.localizeEffect((String)"tooltip.bloodarsenal.bound.shears.desc", (Object[])new Object[0]));
        }
        tooltip.add(TextHelper.localize((String)("tooltip.bloodmagic." + (this.getActivated(stack) ? "activated" : "deactivated")), (Object[])new Object[0]));
        if (!stack.func_77942_o()) {
            return;
        }
        Binding binding = this.getBinding(stack);
        if (binding != null) {
            tooltip.add(TextHelper.localizeEffect((String)"tooltip.bloodmagic.currentOwner", (Object[])new Object[]{binding.getOwnerName()}));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        NetworkHelper.syphonFromContainer((ItemStack)stack, (SoulTicket)SoulTicket.item((ItemStack)stack, (World)worldIn, (Entity)entityLiving, (int)ConfigHandler.values.boundShearsCost));
        Block block = state.func_177230_c();
        if (block instanceof IShearable) {
            return true;
        }
        return state.func_185904_a() != Material.field_151584_j || !EFFECTIVE_BLOCKS.contains(block);
    }

    public boolean func_111207_a(ItemStack itemstack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (target.isShearable(itemstack, (IBlockAccess)entity.field_70170_p, pos)) {
                List drops = target.onSheared(itemstack, (IBlockAccess)entity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemstack));
                Random rand = new Random();
                for (ItemStack stack : drops) {
                    EntityItem ent = entity.func_70099_a(stack, 1.0f);
                    ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                }
                NetworkHelper.getSoulNetwork((EntityPlayer)player).syphonAndDamage(player, SoulTicket.item((ItemStack)itemstack, (World)player.field_70170_p, (Entity)player, (int)ConfigHandler.values.boundShearsCost));
            }
            return true;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        IShearable target;
        if (player.field_70170_p.field_72995_K || player.field_71075_bZ.field_75098_d) {
            return false;
        }
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(itemstack, (IBlockAccess)player.field_70170_p, pos)) {
            List drops = target.onSheared(itemstack, (IBlockAccess)player.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemstack));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                entityitem.func_174869_p();
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            NetworkHelper.getSoulNetwork((EntityPlayer)player).syphonAndDamage(player, SoulTicket.item((ItemStack)itemstack, (World)player.field_70170_p, (Entity)player, (int)ConfigHandler.values.boundShearsCost));
            player.func_71029_a(StatList.func_188055_a((Block)block));
            player.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            this.setActivatedState(stack, !this.getActivated(stack));
        }
        return super.func_77659_a(world, player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshDefinition() {
        return new CustomMeshDefinitionActivatable("bound_shears");
    }

    public void gatherVariants(Consumer<String> variants) {
        variants.accept("active=true");
        variants.accept("active=false");
    }
}

