/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.item.stasis;

import WayofTime.bloodmagic.client.IMeshProvider;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.event.BoundToolEvent;
import WayofTime.bloodmagic.iface.IActivatable;
import WayofTime.bloodmagic.iface.IBindable;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import arcaratus.bloodarsenal.BloodArsenal;
import arcaratus.bloodarsenal.core.RegistrarBloodArsenalItems;
import arcaratus.bloodarsenal.modifier.EnumModifierType;
import arcaratus.bloodarsenal.modifier.IModifiable;
import arcaratus.bloodarsenal.modifier.IModifiableItem;
import arcaratus.bloodarsenal.modifier.Modifier;
import arcaratus.bloodarsenal.modifier.ModifierTracker;
import arcaratus.bloodarsenal.modifier.StasisModifiable;
import arcaratus.bloodarsenal.registry.ModModifiers;
import arcaratus.bloodarsenal.util.BloodArsenalUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;

public abstract class ItemStasisTool
extends ItemTool
implements IBindable,
IActivatable,
IModifiableItem,
IMeshProvider {
    protected final String tooltipBase;
    public Map<ItemStack, Boolean> heldDownMap = new HashMap<ItemStack, Boolean>();
    public Map<ItemStack, Integer> heldDownCountMap = new HashMap<ItemStack, Integer>();
    public final int CHARGE_TIME = 30;
    public int cost = 5;
    private String name;

    public ItemStasisTool(String name, float damage) {
        super(damage, -3.2f, RegistrarBloodArsenalItems.STASIS, BloodArsenalUtils.getEffectiveBlocksForTool(name));
        this.func_77655_b("bloodarsenal.stasis." + name);
        this.setRegistryName("stasis_" + name);
        this.func_77637_a(BloodArsenal.TAB_BLOOD_ARSENAL);
        this.setHarvestLevel(name, 4);
        this.name = name;
        this.tooltipBase = "tooltip.bloodarsenal.stasis." + name + ".";
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (this.getBinding(itemStack) == null) {
            this.setActivatedState(itemStack, false);
            return;
        }
        if (entity instanceof EntityPlayer && this.getActivated(itemStack) && isSelected && this.getBeingHeldDown(itemStack) && itemStack == ((EntityPlayer)entity).func_184607_cu()) {
            EntityPlayer player = (EntityPlayer)entity;
            this.setHeldDownCount(itemStack, Math.min(player.func_184605_cv(), 30));
        } else if (!isSelected) {
            this.setBeingHeldDown(itemStack, false);
        }
        if (entity instanceof EntityPlayer) {
            StasisModifiable modifiable = StasisModifiable.getModifiableFromStack(itemStack);
            if (this.getActivated(itemStack)) {
                modifiable.onUpdate(itemStack, world, entity, itemSlot);
                if (world.func_82737_E() % 80L == 0L) {
                    NetworkHelper.getSoulNetwork((UUID)this.getBinding(itemStack).getOwnerId()).syphonAndDamage((EntityPlayer)entity, SoulTicket.item((ItemStack)itemStack, (World)world, (Entity)entity, (int)this.cost));
                }
            } else {
                modifiable.checkAndIncrementTracker(itemStack, ModModifiers.MODIFIER_SHADOW_TOOL);
            }
        }
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase target, EntityLivingBase attacker) {
        StasisModifiable modifiable = StasisModifiable.getModifiableFromStack(itemStack);
        if (this.getActivated(itemStack)) {
            modifiable.hitEntity(itemStack, target, attacker);
        } else {
            modifiable.checkAndIncrementTracker(itemStack, ModModifiers.MODIFIER_SHADOW_TOOL);
        }
        return true;
    }

    public boolean func_179218_a(ItemStack itemStack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLivingBase) {
        if (!world.field_72995_K) {
            StasisModifiable modifiable = StasisModifiable.getModifiableFromStack(itemStack);
            if (this.getActivated(itemStack)) {
                if (entityLivingBase instanceof EntityPlayer) {
                    modifiable.onBlockDestroyed(itemStack, world, state, pos, (EntityPlayer)entityLivingBase);
                } else {
                    modifiable.checkAndIncrementTracker(itemStack, ModModifiers.MODIFIER_SHADOW_TOOL);
                }
            }
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            this.setActivatedState(itemStack, !this.getActivated(itemStack));
        }
        if (!player.func_70093_af() && this.getActivated(itemStack)) {
            StasisModifiable modifiable = StasisModifiable.getModifiableFromStack(itemStack);
            Modifier modifier = Modifier.EMPTY_MODIFIER;
            for (Map.Entry<String, Pair<Modifier, ModifierTracker>> entry : modifiable.getModifierMap().entrySet()) {
                if (((Modifier)entry.getValue().getLeft()).getType() != EnumModifierType.ABILITY) continue;
                modifier = (Modifier)entry.getValue().getLeft();
                break;
            }
            if (modifier != Modifier.EMPTY_MODIFIER) {
                if (modifier.getAction() == EnumAction.BOW) {
                    BoundToolEvent.Charge event = new BoundToolEvent.Charge(player, itemStack);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)event.result);
                    }
                    player.func_184598_c(hand);
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
                }
                if (!world.field_72995_K) {
                    modifiable.onRightClick(itemStack, world, player);
                }
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77615_a(ItemStack itemStack, World world, EntityLivingBase entityLiving, int timeLeft) {
        EntityPlayer player;
        if (entityLiving instanceof EntityPlayer && !(player = (EntityPlayer)entityLiving).func_70093_af() && this.getActivated(itemStack)) {
            int i = this.func_77626_a(itemStack) - timeLeft;
            BoundToolEvent.Release event = new BoundToolEvent.Release(player, itemStack, i);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            i = event.charge;
            StasisModifiable modifiable = StasisModifiable.getModifiableFromStack(itemStack);
            modifiable.onRelease(itemStack, world, player, i);
            this.setBeingHeldDown(itemStack, false);
        }
    }

    public float func_150893_a(ItemStack itemStack, IBlockState state) {
        StasisModifiable modifiable = StasisModifiable.getModifiableFromStack(itemStack);
        return this.getActivated(itemStack) ? this.field_77864_a : (modifiable.hasModifier(ModModifiers.MODIFIER_SHADOW_TOOL) ? this.field_77864_a * (((float)modifiable.getTrackerForModifier(ModModifiers.MODIFIER_SHADOW_TOOL).getLevel() + 1.0f) / 3.0f) : 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack itemStack) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack) || slotChanged;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        list.add((Object)Utils.setUnbreakable((ItemStack)new ItemStack((Item)this)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (!itemStack.func_77942_o()) {
            return;
        }
        if (Keyboard.isKeyDown((int)42)) {
            StasisModifiable modifiable = StasisModifiable.getModifiableFromStack(itemStack);
            for (EnumModifierType type : EnumModifierType.values()) {
                tooltip.add(TextHelper.localize((String)("tooltip.bloodarsenal.modifier_type." + WordUtils.swapCase((String)type.toString())), (Object[])new Object[0]));
                for (Pair<Modifier, ModifierTracker> entry : modifiable.getModifierMap().values()) {
                    Modifier modifier = (Modifier)entry.getLeft();
                    ModifierTracker tracker = (ModifierTracker)entry.getRight();
                    if (modifier == Modifier.EMPTY_MODIFIER || modifier.getType() != type) continue;
                    String name = modifier.hasAltName() ? TextHelper.localize((String)modifier.getAlternateName(itemStack), (Object[])new Object[0]) : TextHelper.localize((String)modifier.getUnlocalizedName(), (Object[])new Object[0]);
                    tooltip.add(" -" + TextHelper.localize((String)"tooltip.bloodarsenal.modifier.level", (Object[])new Object[]{name, tracker.getLevel() + 1, tracker.isReadyToUpgrade() ? "+" : ""}));
                }
            }
        } else {
            tooltip.add(TextHelper.localizeEffect((String)"tooltip.bloodarsenal.hold_shift", (Object[])new Object[0]));
        }
        super.func_77624_a(itemStack, world, tooltip, flag);
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, EntityLivingBase entityLiving) {
        return itemStack;
    }

    public int func_77626_a(ItemStack itemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        StasisModifiable modifiable = StasisModifiable.getModifiableFromStack(itemStack);
        Modifier modifier = Modifier.EMPTY_MODIFIER;
        for (Pair<Modifier, ModifierTracker> entry : modifiable.getModifierMap().values()) {
            if (((Modifier)entry.getLeft()).getType() != EnumModifierType.ABILITY) continue;
            modifier = (Modifier)entry.getLeft();
            break;
        }
        return modifier != Modifier.EMPTY_MODIFIER ? modifier.getAction() : EnumAction.NONE;
    }

    public Set<String> getToolClasses(ItemStack itemStack) {
        return ImmutableSet.of((Object)this.name);
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return this.getActivated(itemStack) && this.getBeingHeldDown(itemStack);
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return (double)(-Math.min(this.getHeldDownCount(itemStack), 30)) / 30.0 + 1.0;
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.RARE;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack itemStack) {
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            StasisModifiable modifiable = StasisModifiable.getModifiableFromStack(itemStack);
            if (this.getActivated(itemStack)) {
                return modifiable.getAttributeModifiers();
            }
            HashMultimap map = HashMultimap.create();
            if (modifiable.hasModifier(ModModifiers.MODIFIER_SHADOW_TOOL)) {
                int level = modifiable.getTrackerForModifier(ModModifiers.MODIFIER_SHADOW_TOOL.getUniqueIdentifier()).getLevel() + 1;
                map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 4.7 * (double)level / 3.0, 0));
                map.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.8, 0));
            } else {
                map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 0.0, 0));
                map.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.8, 0));
            }
            return map;
        }
        return super.getAttributeModifiers(equipmentSlot, itemStack);
    }

    @Override
    public IModifiable getModifiable(ItemStack itemStack) {
        return StasisModifiable.getModifiableFromStack(itemStack);
    }

    @Nullable
    public ResourceLocation getCustomLocation() {
        return null;
    }

    public void gatherVariants(Consumer<String> variants) {
        variants.accept("active=true");
        variants.accept("active=false");
    }

    protected int getHeldDownCount(ItemStack itemStack) {
        if (!this.heldDownCountMap.containsKey(itemStack)) {
            return 0;
        }
        return this.heldDownCountMap.get(itemStack);
    }

    protected void setHeldDownCount(ItemStack itemStack, int count) {
        this.heldDownCountMap.put(itemStack, count);
    }

    protected boolean getBeingHeldDown(ItemStack itemStack) {
        if (!this.heldDownMap.containsKey(itemStack)) {
            return false;
        }
        return this.heldDownMap.get(itemStack);
    }

    protected void setBeingHeldDown(ItemStack itemStack, boolean heldDown) {
        this.heldDownMap.put(itemStack, heldDown);
    }
}

