/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.item.baubles;

import WayofTime.bloodmagic.client.IMeshProvider;
import WayofTime.bloodmagic.iface.IMultiWillTool;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.soul.IDemonWill;
import WayofTime.bloodmagic.soul.IDemonWillGem;
import WayofTime.bloodmagic.soul.PlayerDemonWillHandler;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import arcaratus.bloodarsenal.client.mesh.CustomMeshDefinitionSoulPendant;
import arcaratus.bloodarsenal.item.baubles.ItemBauble;
import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSoulPendant
extends ItemBauble
implements IDemonWillGem,
IMeshProvider,
IMultiWillTool {
    public static String[] names = new String[]{"petty", "lesser", "common", "greater", "grand"};

    public ItemSoulPendant(String name) {
        super(name, BaubleType.AMULET);
        this.func_77627_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        ItemStack stack = event.getItem().func_92059_d();
        if (stack.func_77973_b() instanceof IDemonWill) {
            EntityPlayer player = event.getEntityPlayer();
            EnumDemonWillType pickupType = ((IDemonWill)stack.func_77973_b()).getType(stack);
            ItemStack remainder = ItemSoulPendant.addDemonWill(player, stack);
            if (remainder.func_190926_b() || ((IDemonWill)stack.func_77973_b()).getWill(pickupType, stack) < 1.0E-4 || ItemSoulPendant.isDemonWillFull(pickupType, player)) {
                stack.func_190920_e(0);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    public static boolean isDemonWillFull(EnumDemonWillType type, EntityPlayer player) {
        NonNullList inventory = NonNullList.func_191196_a();
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int i = 0; i < baubles.getSlots(); ++i) {
            inventory.add((Object)baubles.getStackInSlot(i));
        }
        inventory.addAll((Collection)player.field_71071_by.field_70462_a);
        boolean hasGem = false;
        for (ItemStack stack : inventory) {
            if (!(stack.func_77973_b() instanceof IDemonWillGem)) continue;
            hasGem = true;
            if (!(((IDemonWillGem)stack.func_77973_b()).getWill(type, stack) < (double)((IDemonWillGem)stack.func_77973_b()).getMaxWill(type, stack))) continue;
            return false;
        }
        return hasGem;
    }

    public static ItemStack addDemonWill(EntityPlayer player, ItemStack willStack) {
        if (willStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        NonNullList inventory = NonNullList.func_191196_a();
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int i = 0; i < baubles.getSlots(); ++i) {
            inventory.add((Object)baubles.getStackInSlot(i));
        }
        inventory.addAll((Collection)player.field_71071_by.field_70462_a);
        for (ItemStack stack : inventory) {
            ItemStack newStack;
            if (!(stack.func_77973_b() instanceof IDemonWillGem) || !(newStack = ((IDemonWillGem)stack.func_77973_b()).fillDemonWillGem(stack, willStack)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return willStack;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + names[stack.func_77952_i()];
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (PlayerHelper.isFakePlayer((EntityPlayer)player)) {
            return super.func_77659_a(world, player, hand);
        }
        EnumDemonWillType type = this.getCurrentType(stack);
        double drain = Math.min(this.getWill(type, stack), (double)(this.getMaxWill(type, stack) / 10));
        double filled = PlayerDemonWillHandler.addDemonWill((EnumDemonWillType)type, (EntityPlayer)player, (double)drain, (ItemStack)stack);
        this.drainWill(type, stack, filled, true);
        return super.func_77659_a(world, player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshDefinition() {
        return new CustomMeshDefinitionSoulPendant("soul_pendant");
    }

    public void gatherVariants(Consumer<String> variants) {
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            variants.accept("type=petty_" + type.func_176610_l().toLowerCase());
            variants.accept("type=lesser_" + type.func_176610_l().toLowerCase());
            variants.accept("type=common_" + type.func_176610_l().toLowerCase());
            variants.accept("type=greater_" + type.func_176610_l().toLowerCase());
            variants.accept("type=grand_" + type.func_176610_l().toLowerCase());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            ItemStack emptyStack = new ItemStack((Item)this, 1, i);
            list.add((Object)emptyStack);
        }
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            for (int i = 0; i < names.length; ++i) {
                ItemStack fullStack = new ItemStack((Item)this, 1, i);
                this.setWill(type, fullStack, this.getMaxWill(EnumDemonWillType.DEFAULT, fullStack));
                list.add((Object)fullStack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        EnumDemonWillType type = this.getCurrentType(stack);
        tooltip.add(TextHelper.localize((String)("tooltip.bloodarsenal.soul_pendant." + names[stack.func_77952_i()]), (Object[])new Object[0]));
        tooltip.add(TextHelper.localize((String)"tooltip.bloodmagic.will", (Object[])new Object[]{this.getWill(type, stack)}));
        tooltip.add(TextHelper.localizeEffect((String)("tooltip.bloodmagic.currentType." + this.getCurrentType(stack).func_176610_l().toLowerCase()), (Object[])new Object[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        EnumDemonWillType type = this.getCurrentType(stack);
        double maxWill = this.getMaxWill(type, stack);
        if (maxWill <= 0.0) {
            return 1.0;
        }
        return 1.0 - this.getWill(type, stack) / maxWill;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        EnumDemonWillType type = this.getCurrentType(stack);
        double maxWill = this.getMaxWill(type, stack);
        if (maxWill <= 0.0) {
            return 1;
        }
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)this.getWill(type, stack) / (float)maxWill) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public ItemStack fillDemonWillGem(ItemStack soulGemStack, ItemStack soulStack) {
        if (soulStack.func_77973_b() instanceof IDemonWill) {
            EnumDemonWillType thisType = this.getCurrentType(soulGemStack);
            if (thisType != ((IDemonWill)soulStack.func_77973_b()).getType(soulStack)) {
                return soulStack;
            }
            IDemonWill soul = (IDemonWill)soulStack.func_77973_b();
            double soulsLeft = this.getWill(thisType, soulGemStack);
            if (soulsLeft < (double)this.getMaxWill(thisType, soulGemStack)) {
                double newSoulsLeft = Math.min(soulsLeft + soul.getWill(thisType, soulStack), (double)this.getMaxWill(thisType, soulGemStack));
                soul.drainWill(thisType, soulStack, newSoulsLeft - soulsLeft);
                this.setWill(thisType, soulGemStack, newSoulsLeft);
                if (soul.getWill(thisType, soulStack) <= 0.0) {
                    return ItemStack.field_190927_a;
                }
            }
        }
        return soulStack;
    }

    public double getWill(EnumDemonWillType type, ItemStack soulGemStack) {
        if (!type.equals((Object)this.getCurrentType(soulGemStack))) {
            return 0.0;
        }
        NBTTagCompound tag = soulGemStack.func_77978_p();
        return tag.func_74769_h("souls");
    }

    public void setWill(EnumDemonWillType type, ItemStack soulGemStack, double souls) {
        this.setCurrentType(type, soulGemStack);
        NBTTagCompound tag = soulGemStack.func_77978_p();
        tag.func_74780_a("souls", souls);
    }

    public double drainWill(EnumDemonWillType type, ItemStack soulGemStack, double drainAmount, boolean doDrain) {
        EnumDemonWillType currentType = this.getCurrentType(soulGemStack);
        if (currentType != type) {
            return 0.0;
        }
        double souls = this.getWill(type, soulGemStack);
        double soulsDrained = Math.min(drainAmount, souls);
        this.setWill(type, soulGemStack, souls - soulsDrained);
        return soulsDrained;
    }

    public int getMaxWill(EnumDemonWillType type, ItemStack soulGemStack) {
        EnumDemonWillType currentType = this.getCurrentType(soulGemStack);
        if (!type.equals((Object)currentType) && currentType != EnumDemonWillType.DEFAULT) {
            return 0;
        }
        switch (soulGemStack.func_77960_j()) {
            case 0: {
                return 64;
            }
            case 1: {
                return 256;
            }
            case 2: {
                return 1024;
            }
            case 3: {
                return 4096;
            }
            case 4: {
                return 16384;
            }
        }
        return 64;
    }

    public EnumDemonWillType getCurrentType(ItemStack soulGemStack) {
        NBTHelper.checkNBT((ItemStack)soulGemStack);
        NBTTagCompound tag = soulGemStack.func_77978_p();
        if (!tag.func_74764_b("demonWillType")) {
            return EnumDemonWillType.DEFAULT;
        }
        return EnumDemonWillType.valueOf((String)tag.func_74779_i("demonWillType").toUpperCase(Locale.ENGLISH));
    }

    public void setCurrentType(EnumDemonWillType type, ItemStack soulGemStack) {
        NBTHelper.checkNBT((ItemStack)soulGemStack);
        NBTTagCompound tag = soulGemStack.func_77978_p();
        if (type == EnumDemonWillType.DEFAULT) {
            if (tag.func_74764_b("demonWillType")) {
                tag.func_82580_o("demonWillType");
            }
            return;
        }
        tag.func_74778_a("demonWillType", type.toString());
    }

    public double fillWill(EnumDemonWillType type, ItemStack stack, double fillAmount, boolean doFill) {
        if (!type.equals((Object)this.getCurrentType(stack)) && this.getWill(this.getCurrentType(stack), stack) > 0.0) {
            return 0.0;
        }
        double current = this.getWill(type, stack);
        double maxWill = this.getMaxWill(type, stack);
        double filled = Math.min(fillAmount, maxWill - current);
        if (filled > 0.0) {
            this.setWill(type, stack, filled + current);
            return filled;
        }
        return 0.0;
    }
}

