/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.block;

import WayofTime.bloodmagic.altar.IBloodAltar;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.orb.IBloodOrb;
import arcaratus.bloodarsenal.BloodArsenal;
import arcaratus.bloodarsenal.block.IBABlock;
import arcaratus.bloodarsenal.tile.TileAltareAenigmatica;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAltareAenigmatica
extends Block
implements IVariantProvider,
IBABlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool NORTHEAST = PropertyBool.func_177716_a((String)"northeast");
    public static final PropertyBool NORTHWEST = PropertyBool.func_177716_a((String)"northwest");
    private static final ImmutableMap<EnumFacing, AxisAlignedBB> BOUNDS;

    public BlockAltareAenigmatica(String name) {
        super(Material.field_151576_e);
        this.func_149663_c("bloodarsenal." + name);
        this.setRegistryName(name);
        this.func_149647_a(BloodArsenal.TAB_BLOOD_ARSENAL);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTHEAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTHWEST, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        this.checkFacingAltar((IBlockAccess)worldIn, pos);
        return super.func_189539_a(state, worldIn, pos, id, param);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAltareAenigmatica();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAltareAenigmatica) {
            this.checkFacingAltar((IBlockAccess)world, pos);
            if (player.func_184614_ca().func_77973_b() instanceof IBloodOrb) {
                return ((TileAltareAenigmatica)tile).setLinkedOrbOwner(player);
            }
        }
        player.openGui((Object)BloodArsenal.INSTANCE, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState blockState) {
        TileAltareAenigmatica tile = (TileAltareAenigmatica)world.func_175625_s(pos);
        if (tile != null) {
            tile.dropItems();
        }
        super.func_180663_b(world, pos, blockState);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAltareAenigmatica) {
            this.checkFacingAltar(world, pos);
        }
    }

    private void checkFacingAltar(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAltareAenigmatica) {
            BlockPos altarPos = pos.func_177972_a(((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING)).func_176734_d());
            if (world.func_175625_s(altarPos) instanceof IBloodAltar) {
                ((TileAltareAenigmatica)tile).setAltarPos(altarPos);
            } else {
                ((TileAltareAenigmatica)tile).setAltarPos(BlockPos.field_177992_a);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, NORTH, EAST, NORTHEAST, NORTHWEST});
    }

    public IBlockState func_176203_a(int meta) {
        if (meta >= EnumFacing.values().length) {
            meta = EnumFacing.DOWN.ordinal();
        }
        EnumFacing face = EnumFacing.values()[meta];
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)face);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        int off = -facing.ordinal() % 2;
        EnumFacing face1 = EnumFacing.values()[(facing.ordinal() + 2) % 6];
        EnumFacing face2 = EnumFacing.values()[(facing.ordinal() + 4 + off) % 6];
        IBlockState north = worldIn.func_180495_p(pos.func_177972_a(face1));
        IBlockState east = worldIn.func_180495_p(pos.func_177972_a(face2));
        if (north.func_177230_c() == this && north.func_177229_b((IProperty)FACING) == facing) {
            state = state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(true));
        }
        if (east.func_177230_c() == this && east.func_177229_b((IProperty)FACING) == facing) {
            state = state.func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(true));
        }
        IBlockState northeast = worldIn.func_180495_p(pos.func_177972_a(face1).func_177972_a(face2));
        IBlockState northwest = worldIn.func_180495_p(pos.func_177972_a(face1).func_177972_a(face2.func_176734_d()));
        if (northeast.func_177230_c() == this && northeast.func_177229_b((IProperty)FACING) == facing) {
            state = state.func_177226_a((IProperty)NORTHEAST, (Comparable)Boolean.valueOf(true));
        }
        if (northwest.func_177230_c() == this && northwest.func_177229_b((IProperty)FACING) == facing) {
            state = state.func_177226_a((IProperty)NORTHWEST, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (AxisAlignedBB)BOUNDS.get((Object)state.func_177229_b((IProperty)FACING));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)EnumFacing.DOWN, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0));
        builder.put((Object)EnumFacing.UP, (Object)new AxisAlignedBB(0.0, 0.6875, 0.0, 1.0, 1.0, 1.0));
        builder.put((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.3125));
        builder.put((Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.0, 0.0, 0.6875, 1.0, 1.0, 1.0));
        builder.put((Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.6875, 0.0, 0.0, 1.0, 1.0, 1.0));
        builder.put((Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 0.3125, 1.0, 1.0));
        BOUNDS = builder.build();
    }
}

