/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="bloodarsenal", name="bloodarsenal/bloodarsenal", category="")
@Mod.EventBusSubscriber(modid="bloodarsenal")
public class ConfigHandler {
    @Config.Comment(value={"Blacklist options for various features"})
    public static ConfigBlacklist blacklist = new ConfigBlacklist();
    @Config.Comment(value={"Value modifiers for various features"})
    public static ConfigValues values = new ConfigValues();
    @Config.Comment(value={"Toggles for all rituals"})
    public static ConfigRituals rituals = new ConfigRituals();
    @Config.Comment(value={"Miscellaneous options"})
    public static ConfigMisc misc = new ConfigMisc();
    @Config.Comment(value={"Options for different mod compatibilities"})
    public static ConfigCompat compat = new ConfigCompat();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("bloodarsenal")) {
            ConfigManager.sync((String)event.getModID(), (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class ConfigCompat {
        public boolean tconstructCompatEnabled = true;
    }

    public static class ConfigMisc {
        @Config.Comment(value={"Should be set to false when another mod adds in its own Ore-Dict glass shards"})
        public boolean doGlassShardsDrop = true;
        @Config.Comment(value={"Should glass/bleeding cause less drops"})
        public boolean glassDeathLessDrops = true;
        @Config.Comment(value={"The max range for anything that uses raytracing (Ender Sigil, Lightning Sigil, etc.)"})
        @Config.RangeDouble(min=1.0, max=256.0)
        public double rayTraceRange = 64.0;
    }

    public static class ConfigImperfectRituals {
        public boolean imperfectLightning = true;
        public boolean imperfectEnchantReset = true;
        public boolean imperfectIce = true;
        public boolean imperfectSnow = true;
        @Config.Comment(value={"Activation cost of the Imperfect Lightning Ritual"})
        @Config.RangeInt(min=0, max=100000)
        public int imperfectLightningActivationCost = 5000;
        @Config.Comment(value={"Activation cost of the Enchant Reset Ritual"})
        @Config.RangeInt(min=0, max=100000)
        public int imperfectEnchantResetActivationCost = 5000;
        @Config.Comment(value={"Activation cost of the Imperfect Lightning Ritual"})
        @Config.RangeInt(min=0, max=100000)
        public int imperfectIceActivationCost = 500;
        @Config.Comment(value={"Activation cost of the Imperfect Lightning Ritual"})
        @Config.RangeInt(min=0, max=100000)
        public int imperfectSnowActivationCost = 500;
    }

    public static class ConfigRituals {
        public boolean infusionRitual = true;
        public boolean purificationRitual = true;
        public boolean bloodBurnerRitual = true;
        @Config.Comment(value={"Activation cost of the Infusion de Sanguine (infusionRitual)"})
        @Config.RangeInt(min=0, max=100000)
        public int infusionRitualActivationCost = 10000;
        @Config.Comment(value={"Refresh cost of the Infusion de Sanguine (infusionRitual)"})
        @Config.RangeInt(min=0, max=100000)
        public int infusionRitualRefreshCost = 100;
        @Config.Comment(value={"Activation cost of the Ritual of Purification (purificationRitual)"})
        @Config.RangeInt(min=0, max=100000)
        public int purificationtRitualActivationCost = 10000;
        @Config.Comment(value={"Refresh cost of the Ritual of Purification (purificationRitual)"})
        @Config.RangeInt(min=0, max=100000)
        public int purificationRitualRefreshCost = 20;
        @Config.Comment(value={"Minimum amount of Life Essence (in mB) required to start the Ritual of Purification"})
        @Config.RangeInt(min=0, max=100000)
        public int purificationRitualMinLP = 10000;
        @Config.Comment(value={"Amount of Life Essence (in mB) per mB of Refined Life Essence"})
        @Config.RangeInt(min=1, max=10000)
        public int refinedLifeEssenceConversion = 10;
        @Config.Comment(value={"Activation cost of the Blood Burner Rites (blood_burner)"})
        @Config.RangeInt(min=0, max=100000)
        public int bloodBurnerRitualActivationCost = 10000;
        @Config.Comment(value={"Refresh cost of the Blood Burner Rites (blood_burner)"})
        @Config.RangeInt(min=0, max=100000)
        public int bloodBurnerRitualRefreshCost = 200;
        @Config.Comment(value={"Network drain of the Blood Burner Rites (multiplied by the rate of RF generated)"})
        @Config.RangeInt(min=0, max=100000)
        public int bloodBurnerRitualNetworkCost = 1000;
        public ConfigImperfectRituals imperfect = new ConfigImperfectRituals();
    }

    public static class ConfigValues {
        @Config.Comment(value={"Amount of damage the Glass Shards block deals when an entity touches it"})
        @Config.RangeDouble(min=0.0, max=1000.0)
        public double glassShardsDamage = 2.0;
        @Config.Comment(value={"The multiplier (per item) of LP drained when the Altare Aenigmatica moves an item to the altar"})
        @Config.RangeInt(min=0, max=1000)
        public int altareAenigmaticaMoveMultiplier = 50;
        @Config.Comment(value={"Amount of energy the Blood Capacitor can store"})
        @Config.RangeInt(min=0, max=1000000000)
        public int bloodCapacitorStorage = 10000000;
        @Config.Comment(value={"Amount of energy the Blood Capacitor can transfer per tick"})
        @Config.RangeInt(min=0, max=1000000)
        public int bloodCapacitorTransfer = 10000;
        @Config.Comment(value={"Amount of LP the Glass Sacrificial Dagger (approximately) gives per use"})
        @Config.RangeInt(min=0, max=10000)
        public int glassSacrificialDaggerLP;
        @Config.Comment(value={"Amount of damage the Glass Sacrificial Dagger deals per use"})
        @Config.RangeInt(min=1, max=10000)
        public double glassSacrificialDaggerHealth;
        @Config.Comment(value={"The multiplier of LP for the Glass Dagger of Sacrifice"})
        @Config.RangeDouble(min=1.0, max=1000.0)
        public double glassDaggerOfSacrificeLPMultiplier;
        @Config.Comment(value={"Amount of ticks for a repair to occur for Blood Infused Wooden Tools"})
        @Config.RangeInt(min=0, max=1000)
        public int bloodInfusedWoodenToolsRepairUpdate;
        @Config.Comment(value={"Amount of LP required for a repair for Blood Infused Wooden Tools"})
        @Config.RangeInt(min=0, max=1000)
        public int bloodInfusedWoodenToolsRepairCost;
        @Config.Comment(value={"Amount of ticks for a repair to occur for Blood Infused Iron Tools"})
        @Config.RangeInt(min=0, max=1000)
        public int bloodInfusedIronToolsRepairUpdate;
        @Config.Comment(value={"Amount of LP required for a repair for Blood Infused Iron Tools"})
        @Config.RangeInt(min=0, max=1000)
        public int bloodInfusedIronToolsRepairCost;
        @Config.Comment(value={"Amount of LP required per usage of the Bound Igniter"})
        @Config.RangeInt(min=0, max=10000)
        public int boundIgniterCost;
        @Config.Comment(value={"Amount of LP required per usage of the Bound Shears"})
        @Config.RangeInt(min=0, max=10000)
        public int boundShearsCost;
        @Config.Comment(value={"Amount of LP per update for the Sigil of Swimming"})
        @Config.RangeInt(min=0, max=10000)
        public int sigilSwimmingCost;
        @Config.Comment(value={"Amount of LP required to open the Ender Sigil"})
        @Config.RangeInt(min=0, max=10000)
        public int sigilEnderOpenCost;
        @Config.Comment(value={"Multiplier of LP for teleporting with the Ender Sigil"})
        @Config.RangeDouble(min=0.0, max=10000.0)
        public double sigilEnderTeleportMultiplier;
        @Config.Comment(value={"Time (in ticks) of the delay before teleportation for the Ender Sigil"})
        @Config.RangeInt(min=0, max=60)
        public int sigilEnderTeleportationDelay;
        @Config.Comment(value={"Time (in ticks) of the cooldown after teleportation for the Ender Sigil"})
        @Config.RangeInt(min=0, max=200)
        public int sigilEnderTeleportationCooldown;
        @Config.Comment(value={"Multiplier of LP (per lightning bolt) for zapping things with the Lightning Sigil"})
        @Config.RangeDouble(min=0.0, max=10000.0)
        public double sigilLightningMultiplier;
        @Config.Comment(value={"Amount of LP per update for the Sigil of Divinity"})
        @Config.RangeInt(min=0)
        public int sigilDivinityCost;
        @Config.Comment(value={"Amount of LP per usage for the Sigil of Sentience"})
        @Config.RangeInt(min=0, max=10000)
        public int sigilSentienceBaseCost;
        @Config.Comment(value={"Fraction of the damage that is converted to health for the Vampire Ring: health = (damageDealt * vampireRingSyphon)"})
        @Config.RangeDouble(min=0.0, max=100.0)
        public double vampireRingMultiplier;
        @Config.Comment(value={"Multiplier of LP for the Sacrifice Amulet: LP = (damageDone * sacrificeAmuletMultiplier"})
        @Config.RangeDouble(min=0.0, max=100.0)
        public double sacrificeAmuletMultiplier;
        @Config.Comment(value={"Multiplier of LP for the Self Sacrifice Amulet: LP = (damageDone * sacrificeAmuletMultiplier"})
        @Config.RangeDouble(min=0.0, max=100.0)
        public double selfSacrificeAmuletMultiplier;

        public ConfigValues() {
            this.glassSacrificialDaggerLP = 5 * WayofTime.bloodmagic.ConfigHandler.values.sacrificialDaggerConversion;
            this.glassSacrificialDaggerHealth = 2.0;
            this.glassDaggerOfSacrificeLPMultiplier = 2.0;
            this.bloodInfusedWoodenToolsRepairUpdate = 100;
            this.bloodInfusedWoodenToolsRepairCost = 20;
            this.bloodInfusedIronToolsRepairUpdate = 40;
            this.bloodInfusedIronToolsRepairCost = 50;
            this.boundIgniterCost = 200;
            this.boundShearsCost = 300;
            this.sigilSwimmingCost = 100;
            this.sigilEnderOpenCost = 500;
            this.sigilEnderTeleportMultiplier = 200.0;
            this.sigilEnderTeleportationDelay = 10;
            this.sigilEnderTeleportationCooldown = 40;
            this.sigilLightningMultiplier = 800.0;
            this.sigilDivinityCost = 100000;
            this.sigilSentienceBaseCost = 1000;
            this.vampireRingMultiplier = 0.5;
            this.sacrificeAmuletMultiplier = 20.0;
            this.selfSacrificeAmuletMultiplier = 20.0;
        }
    }

    public static class ConfigBlacklist {
        @Config.Comment(value={"Blacklists the loading of listed items.", "Use the registry name of the item. Vanilla items do not require the modid."})
        public String[] itemBlacklist = new String[0];
        @Config.Comment(value={"Blacklists the loading of listed blocks.", "Use the registry name of the block. Vanilla blocks do not require the modid."})
        public String[] blockBlacklist = new String[0];
    }
}

