/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.energyconverters.common.tiles;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.Info;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.xalcon.energyconverters.common.EnergyConvertersConfig;
import net.xalcon.energyconverters.common.tiles.TileEntityEnergyConvertersConsumer;

@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2", striprefs=true)
public class TileEntityConsumerEu
extends TileEntityEnergyConvertersConsumer
implements ITickable,
IEnergySink {
    private boolean addedToNet;
    private int tier;
    private double tierEnergyMax;

    public TileEntityConsumerEu() {
    }

    public TileEntityConsumerEu(int tier) {
        this.tier = tier;
        this.tierEnergyMax = EnergyNet.instance.getPowerFromTier(this.tier);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tier = compound.func_74762_e("tier");
        this.tierEnergyMax = EnergyNet.instance.getPowerFromTier(this.tier);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("tier", this.tier);
        return super.func_189515_b(compound);
    }

    private void onLoaded() {
        super.onLoad();
        if (this.addedToNet || FMLCommonHandler.instance().getEffectiveSide().isClient() || !Info.isIc2Available()) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
        this.addedToNet = true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.addedToNet && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToNet = false;
        }
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.addedToNet) {
            this.onLoaded();
        }
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        double demand = this.getBridgeEnergyStoredMax() - this.getBridgeEnergyStored();
        if (demand > 0.0) {
            return Math.min(demand, this.tierEnergyMax);
        }
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return this.tier;
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing enumFacing, double amount, double tier) {
        double ratio = EnergyConvertersConfig.ic2Conversion;
        return amount - this.addEnergyToBridge(amount * ratio, false) / ratio;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing enumFacing) {
        return true;
    }
}

