/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.energyconverters.common.crafting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.xalcon.energyconverters.common.crafting.IngredientNBTEx;

public class IngredientFactoryVanillaNBT
implements IIngredientFactory {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    @Nonnull
    public Ingredient parse(JsonContext context, JsonObject json) {
        String itemName = context.appendModId(JsonUtils.func_151200_h((JsonObject)json, (String)"item"));
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        if (item.func_77614_k() && !json.has("data")) {
            throw new JsonParseException("Missing data for item '" + itemName + "'");
        }
        if (json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                NBTTagCompound nbt = element.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(element)) : JsonToNBT.func_180713_a((String)element.getAsString());
                NBTTagCompound tmp = new NBTTagCompound();
                if (nbt.func_74764_b("ForgeCaps")) {
                    tmp.func_74782_a("ForgeCaps", nbt.func_74781_a("ForgeCaps"));
                    nbt.func_82580_o("ForgeCaps");
                }
                tmp.func_74782_a("tag", (NBTBase)nbt);
                tmp.func_74778_a("id", itemName);
                tmp.func_74768_a("Count", JsonUtils.func_151208_a((JsonObject)json, (String)"count", (int)1));
                tmp.func_74768_a("Damage", JsonUtils.func_151208_a((JsonObject)json, (String)"data", (int)0));
                return new IngredientNBTEx(new ItemStack(tmp));
            }
            catch (NBTException e) {
                throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
            }
        }
        return new IngredientNBTEx(new ItemStack(item, JsonUtils.func_151208_a((JsonObject)json, (String)"count", (int)1), JsonUtils.func_151208_a((JsonObject)json, (String)"data", (int)0)));
    }
}

