/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.proxy;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.animation.AnimationTESR;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.blocks.ITetraBlock;
import se.mickelus.tetra.blocks.forged.BlockForgedCrate;
import se.mickelus.tetra.blocks.forged.container.BlockForgedContainer;
import se.mickelus.tetra.blocks.forged.container.TESRForgedContainer;
import se.mickelus.tetra.blocks.forged.container.TileEntityForgedContainer;
import se.mickelus.tetra.blocks.forged.extractor.BlockSeepingBedrock;
import se.mickelus.tetra.blocks.forged.extractor.TileEntityCoreExtractorPiston;
import se.mickelus.tetra.blocks.hammer.TileEntityHammerHead;
import se.mickelus.tetra.blocks.salvage.CapabililtyInteractiveOverlay;
import se.mickelus.tetra.blocks.workbench.TESRWorkbench;
import se.mickelus.tetra.blocks.workbench.TileEntityWorkbench;
import se.mickelus.tetra.client.model.ModularModelLoader;
import se.mickelus.tetra.generation.ExtendedStructureTESR;
import se.mickelus.tetra.items.ITetraItem;
import se.mickelus.tetra.items.toolbelt.OverlayToolbelt;
import se.mickelus.tetra.items.toolbelt.booster.OverlayBooster;
import se.mickelus.tetra.proxy.IProxy;

public class ClientProxy
implements IProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event, ITetraItem[] items, ITetraBlock[] blocks) {
        Arrays.stream(items).forEach(ITetraItem::clientPreInit);
        Arrays.stream(blocks).forEach(ITetraBlock::clientPreInit);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWorkbench.class, (TileEntitySpecialRenderer)new TESRWorkbench());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityHammerHead.class, (TileEntitySpecialRenderer)new AnimationTESR());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCoreExtractorPiston.class, (TileEntitySpecialRenderer)new AnimationTESR());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityForgedContainer.class, (TileEntitySpecialRenderer)new TESRForgedContainer());
        if (ConfigHandler.development) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityStructure.class, (TileEntitySpecialRenderer)new ExtendedStructureTESR());
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new OverlayToolbelt(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new OverlayBooster(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new CapabililtyInteractiveOverlay());
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        if (ConfigHandler.generateFeatures) {
            ModelLoader.setCustomStateMapper((Block)BlockForgedContainer.instance, (IStateMapper)new StateMapperBase(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    return new ModelResourceLocation("tetra:forged_container");
                }
            });
            ModelLoader.setCustomStateMapper((Block)BlockForgedCrate.instance, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockForgedCrate.propIntegrity}).func_178441_a());
            ModelLoader.setCustomStateMapper((Block)BlockSeepingBedrock.instance, (IStateMapper)new StateMapperBase(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    return new ModelResourceLocation("tetra:seeping_bedrock", "active=" + ((Integer)state.func_177229_b((IProperty)BlockSeepingBedrock.propActive) > 0));
                }
            });
        }
    }

    static {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModularModelLoader.instance);
    }
}

