/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schema;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schema.BaseSchema;
import se.mickelus.tetra.module.schema.SchemaType;
import se.mickelus.tetra.util.CastOptional;

public class RepairSchema
extends BaseSchema {
    private static final String nameSuffix = ".name";
    private static final String descriptionSuffix = ".description";
    private static final String extendedDescriptionSuffix = ".description_details";
    private String key = "repair_schema";
    private ItemModular item;
    private GlyphData glyph = new GlyphData("textures/gui/workbench.png", 0, 52);

    public RepairSchema(ItemModular item) {
        this.item = item;
        ItemUpgradeRegistry.instance.registerSchema(this);
    }

    public String getSlot(ItemStack itemStack) {
        return CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).map(item -> item.getRepairSlot(itemStack)).orElse(null);
    }

    @Override
    public String getKey() {
        return this.key + "/" + this.item.func_77658_a();
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)(this.key + nameSuffix), (Object[])new Object[0]);
    }

    @Override
    public String getDescription(@Nullable ItemStack itemStack) {
        if (itemStack != null) {
            return CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).map(item -> I18n.func_135052_a((String)(this.key + extendedDescriptionSuffix), (Object[])new Object[]{item.getRepairModuleName(itemStack), item.getRepairAmount(itemStack)})).orElse(I18n.func_135052_a((String)(this.key + descriptionSuffix), (Object[])new Object[0]));
        }
        return I18n.func_135052_a((String)(this.key + descriptionSuffix), (Object[])new Object[0]);
    }

    @Override
    public int getNumMaterialSlots() {
        return 1;
    }

    @Override
    public String getSlotName(ItemStack itemStack, int index) {
        if (itemStack.func_77973_b() instanceof ItemModular) {
            ItemModular item = (ItemModular)itemStack.func_77973_b();
            return item.getRepairMaterial(itemStack).getDisplayName();
        }
        return "?";
    }

    @Override
    public int getRequiredQuantity(ItemStack itemStack, int index, ItemStack materialStack) {
        if (index == 0 && itemStack.func_77973_b() instanceof ItemModular) {
            ItemModular item = (ItemModular)itemStack.func_77973_b();
            return item.getRepairMaterialCount(itemStack);
        }
        return 0;
    }

    @Override
    public boolean acceptsMaterial(ItemStack itemStack, int index, ItemStack materialStack) {
        if (index == 0 && itemStack.func_77973_b() instanceof ItemModular) {
            ItemModular item = (ItemModular)itemStack.func_77973_b();
            return item.getRepairMaterial((ItemStack)itemStack).predicate.func_192493_a(materialStack);
        }
        return false;
    }

    @Override
    public boolean isApplicableForItem(ItemStack itemStack) {
        return this.item.getClass().isInstance(itemStack.func_77973_b());
    }

    @Override
    public boolean isApplicableForSlot(String slot, ItemStack targetStack) {
        return slot == null;
    }

    @Override
    public ItemStack applyUpgrade(ItemStack itemStack, ItemStack[] materials, boolean consumeMaterials, String slot, EntityPlayer player) {
        ItemStack upgradedStack = itemStack.func_77946_l();
        ItemModular item = (ItemModular)upgradedStack.func_77973_b();
        int quantity = this.getRequiredQuantity(itemStack, 0, materials[0]);
        item.repair(upgradedStack);
        if (consumeMaterials) {
            materials[0].func_190918_g(quantity);
        }
        return upgradedStack;
    }

    @Override
    public boolean isMaterialsValid(ItemStack itemStack, ItemStack[] materials) {
        return this.acceptsMaterial(itemStack, 0, materials[0]) && materials[0].func_190916_E() >= this.getRequiredQuantity(itemStack, 0, materials[0]);
    }

    @Override
    public boolean isIntegrityViolation(EntityPlayer player, ItemStack itemStack, ItemStack[] materials, String slot) {
        return false;
    }

    @Override
    public Collection<Capability> getRequiredCapabilities(ItemStack targetStack, ItemStack[] materials) {
        if (targetStack.func_77973_b() instanceof ItemModular) {
            ItemModular item = (ItemModular)targetStack.func_77973_b();
            return item.getRepairRequiredCapabilities(targetStack);
        }
        return Collections.emptyList();
    }

    @Override
    public int getRequiredCapabilityLevel(ItemStack targetStack, ItemStack[] materials, Capability capability) {
        if (targetStack.func_77973_b() instanceof ItemModular) {
            ItemModular item = (ItemModular)targetStack.func_77973_b();
            return item.getRepairRequiredCapabilityLevel(targetStack, capability);
        }
        return 0;
    }

    @Override
    public int getExperienceCost(ItemStack targetStack, ItemStack[] materials, String slot) {
        if (targetStack.func_77973_b() instanceof ItemModular) {
            ItemModular item = (ItemModular)targetStack.func_77973_b();
            return item.getRepairRequiredExperience(targetStack);
        }
        return 0;
    }

    @Override
    public SchemaType getType() {
        return SchemaType.other;
    }

    @Override
    public GlyphData getGlyph() {
        return this.glyph;
    }
}

