/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.advancements.ImprovementCraftCriterion;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schema.OutcomePreview;
import se.mickelus.tetra.module.schema.SchemaType;
import se.mickelus.tetra.module.schema.UpgradeSchema;

public class BookEnchantSchema
implements UpgradeSchema {
    private static final String key = "book_enchant";
    private static final String nameSuffix = ".name";
    private static final String descriptionSuffix = ".description";
    private static final String slotSuffix = ".slot1";
    protected ItemModuleMajor module;
    private GlyphData glyph = new GlyphData("textures/gui/workbench.png", 80, 32);

    public BookEnchantSchema(ItemModuleMajor module) {
        this.module = module;
        ItemUpgradeRegistry.instance.registerSchema(this);
    }

    @Override
    public String getKey() {
        return "book_enchant/" + this.module.getKey();
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)"book_enchant.name", (Object[])new Object[0]);
    }

    @Override
    public String getDescription(ItemStack itemStack) {
        return I18n.func_135052_a((String)"book_enchant.description", (Object[])new Object[0]);
    }

    @Override
    public int getNumMaterialSlots() {
        return 1;
    }

    @Override
    public String getSlotName(ItemStack itemStack, int index) {
        return I18n.func_135052_a((String)"book_enchant.slot1", (Object[])new Object[0]);
    }

    @Override
    public int getRequiredQuantity(ItemStack itemStack, int index, ItemStack materialStack) {
        return 1;
    }

    @Override
    public boolean acceptsMaterial(ItemStack itemStack, int index, ItemStack materialStack) {
        return !materialStack.func_190926_b() && materialStack.func_77973_b() instanceof ItemEnchantedBook;
    }

    @Override
    public boolean isMaterialsValid(ItemStack itemStack, ItemStack[] materials) {
        if (this.acceptsMaterial(itemStack, 0, materials[0])) {
            return EnchantmentHelper.func_82781_a((ItemStack)materials[0]).entrySet().stream().anyMatch(entry -> {
                String improvementKey = ItemUpgradeRegistry.instance.getImprovementFromEnchantment((Enchantment)entry.getKey());
                return this.module.acceptsImprovementLevel(improvementKey, (Integer)entry.getValue());
            });
        }
        return false;
    }

    @Override
    public boolean isApplicableForItem(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemModular) {
            ItemModular item = (ItemModular)itemStack.func_77973_b();
            return item.hasModule(itemStack, this.module);
        }
        return false;
    }

    @Override
    public boolean isApplicableForSlot(String slot, ItemStack targetStack) {
        return this.module.getSlot().equals(slot);
    }

    @Override
    public boolean canApplyUpgrade(EntityPlayer player, ItemStack itemStack, ItemStack[] materials, String slot, int[] availableCapabilities) {
        return this.isMaterialsValid(itemStack, materials) && player.field_71068_ca >= this.getExperienceCost(itemStack, materials, slot);
    }

    @Override
    public boolean isIntegrityViolation(EntityPlayer player, ItemStack itemStack, ItemStack[] materials, String slot) {
        return false;
    }

    @Override
    public ItemStack applyUpgrade(ItemStack itemStack, ItemStack[] materials, boolean consumeMaterials, String slot, EntityPlayer player) {
        ItemStack upgradedStack = itemStack.func_77946_l();
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)materials[0]);
        for (Map.Entry entry : enchantments.entrySet()) {
            String improvement = ItemUpgradeRegistry.instance.getImprovementFromEnchantment((Enchantment)entry.getKey());
            if (!this.module.acceptsImprovementLevel(improvement, (Integer)entry.getValue())) continue;
            this.module.addImprovement(upgradedStack, improvement, (Integer)entry.getValue());
            if (!consumeMaterials || !(player instanceof EntityPlayerMP)) continue;
            ImprovementCraftCriterion.trigger((EntityPlayerMP)player, itemStack, upgradedStack, this.getKey(), slot, improvement, (Integer)entry.getValue(), null, -1);
        }
        if (consumeMaterials) {
            materials[0].func_190918_g(1);
        }
        return upgradedStack;
    }

    @Override
    public boolean checkCapabilities(ItemStack targetStack, ItemStack[] materials, int[] availableCapabilities) {
        return true;
    }

    @Override
    public Collection<Capability> getRequiredCapabilities(ItemStack targetStack, ItemStack[] materials) {
        return Collections.emptyList();
    }

    @Override
    public int getRequiredCapabilityLevel(ItemStack targetStack, ItemStack[] materials, Capability capability) {
        return 0;
    }

    @Override
    public int getExperienceCost(ItemStack targetStack, ItemStack[] materials, String slot) {
        int cost = 0;
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)materials[0]);
        for (Map.Entry entry : enchantments.entrySet()) {
            String improvement = ItemUpgradeRegistry.instance.getImprovementFromEnchantment((Enchantment)entry.getKey());
            if (!this.module.acceptsImprovementLevel(improvement, (Integer)entry.getValue())) continue;
            cost += ((Integer)entry.getValue()).intValue();
        }
        int capacityPenalty = Math.max(0, -this.module.getMagicCapacity(targetStack));
        return cost + capacityPenalty;
    }

    @Override
    public SchemaType getType() {
        return SchemaType.improvement;
    }

    @Override
    public GlyphData getGlyph() {
        return this.glyph;
    }

    @Override
    public OutcomePreview[] getPreviews(ItemStack targetStack, String slot) {
        return new OutcomePreview[0];
    }
}

