/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import se.mickelus.tetra.data.DataHandler;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.data.ImprovementData;
import se.mickelus.tetra.module.data.ModuleData;

public class MultiSlotModule<T extends ModuleData>
extends ItemModuleMajor<T> {
    protected String slotSuffix;
    protected String unlocalizedName;

    public MultiSlotModule(String slotKey, String moduleKey, String slotSuffix, String ... improvementKeys) {
        super(slotKey, moduleKey + slotSuffix);
        this.slotSuffix = slotSuffix;
        this.unlocalizedName = moduleKey;
        this.dataKey = moduleKey + slotSuffix + "_material";
        if (improvementKeys.length > 0) {
            this.improvements = (ImprovementData[])Arrays.stream(improvementKeys).map(key -> DataHandler.instance.getModuleData((String)key, ImprovementData[].class)).flatMap(Arrays::stream).toArray(ImprovementData[]::new);
        }
        this.settleMax = Arrays.stream(this.improvements).filter(data -> data.key.equals("settled")).mapToInt(ImprovementData::getLevel).max().orElse(0);
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Override
    public ResourceLocation[] getAllTextures() {
        return (ResourceLocation[])Arrays.stream(this.data).map(moduleData -> moduleData.key).map(key -> "items/" + key + this.slotSuffix).map(key -> new ResourceLocation("tetra", key)).toArray(ResourceLocation[]::new);
    }

    @Override
    public ResourceLocation[] getTextures(ItemStack itemStack) {
        String string = "items/" + ((ModuleData)this.getData((ItemStack)itemStack)).key + this.slotSuffix;
        return new ResourceLocation[]{new ResourceLocation("tetra", string)};
    }
}

