/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import se.mickelus.tetra.data.DataHandler;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ReplacementDefinition;
import se.mickelus.tetra.module.schema.ConfigSchema;
import se.mickelus.tetra.module.schema.InvalidSchemaException;
import se.mickelus.tetra.module.schema.OutcomeDefinition;
import se.mickelus.tetra.module.schema.RepairDefinition;
import se.mickelus.tetra.module.schema.SchemaDefinition;
import se.mickelus.tetra.module.schema.UpgradeSchema;

public class ItemUpgradeRegistry {
    public static ItemUpgradeRegistry instance;
    private List<Function<ItemStack, ItemStack>> replacementFunctions;
    private List<ReplacementDefinition> replacementDefinitions;
    private Map<String, UpgradeSchema> schemaMap;
    private Map<String, RepairDefinition> repairMap;
    private Map<String, ItemModule> moduleMap;

    public ItemUpgradeRegistry() {
        instance = this;
        this.replacementFunctions = new ArrayList<Function<ItemStack, ItemStack>>();
        this.replacementDefinitions = new ArrayList<ReplacementDefinition>();
        this.schemaMap = new HashMap<String, UpgradeSchema>();
        this.repairMap = new HashMap<String, RepairDefinition>();
        this.moduleMap = new HashMap<String, ItemModule>();
    }

    public UpgradeSchema[] getAvailableSchemas(EntityPlayer player, ItemStack itemStack) {
        return (UpgradeSchema[])this.schemaMap.values().stream().filter(upgradeSchema -> this.playerHasSchema(player, itemStack, (UpgradeSchema)upgradeSchema)).filter(upgradeSchema -> upgradeSchema.isApplicableForItem(itemStack)).toArray(UpgradeSchema[]::new);
    }

    public UpgradeSchema[] getSchemas(String slot) {
        return (UpgradeSchema[])this.schemaMap.values().stream().filter(upgradeSchema -> upgradeSchema.isApplicableForSlot(slot, ItemStack.field_190927_a)).toArray(UpgradeSchema[]::new);
    }

    public UpgradeSchema getSchema(String key) {
        return this.schemaMap.get(key);
    }

    public boolean playerHasSchema(EntityPlayer player, ItemStack targetStack, UpgradeSchema schema) {
        return schema.isVisibleForPlayer(player, targetStack);
    }

    public void registerSchema(UpgradeSchema upgradeSchema) {
        this.schemaMap.put(upgradeSchema.getKey(), upgradeSchema);
    }

    public void registerConfigSchema(String path) {
        for (SchemaDefinition definition : DataHandler.instance.getSchemaDefinitions(path)) {
            if (definition.slots.length == definition.keySuffixes.length) {
                for (int i = 0; i < definition.slots.length; ++i) {
                    try {
                        this.registerConfigSchema(definition, new ConfigSchema(definition, definition.keySuffixes[i], definition.slots[i]));
                        continue;
                    }
                    catch (InvalidSchemaException e) {
                        e.printMessage();
                    }
                }
                continue;
            }
            try {
                this.registerConfigSchema(definition, new ConfigSchema(definition));
            }
            catch (InvalidSchemaException e) {
                e.printMessage();
            }
        }
    }

    private void registerConfigSchema(SchemaDefinition definition, ConfigSchema schema) throws InvalidSchemaException {
        this.registerSchema(schema);
        if (definition.repair) {
            for (OutcomeDefinition outcomeDefinition : definition.outcomes) {
                if (!RepairDefinition.validateOutcome(outcomeDefinition)) continue;
                this.registerRepairDefinition(new RepairDefinition(outcomeDefinition));
            }
        }
    }

    public void registerRepairDefinition(RepairDefinition definition) {
        if (!this.repairMap.containsKey(definition.moduleVariant)) {
            this.repairMap.put(definition.moduleVariant, definition);
        }
    }

    public RepairDefinition getRepairDefinition(String moduleVariant) {
        return this.repairMap.get(moduleVariant);
    }

    public void registerReplacementDefinition(String path) {
        Collections.addAll(this.replacementDefinitions, DataHandler.instance.getReplacementDefinition(path));
    }

    public void registerReplacementFunction(Function<ItemStack, ItemStack> replacementFunction) {
        this.replacementFunctions.add(replacementFunction);
    }

    public ItemStack getReplacement(ItemStack itemStack) {
        for (ReplacementDefinition replacementDefinition : this.replacementDefinitions) {
            if (!replacementDefinition.predicate.func_192493_a(itemStack)) continue;
            ItemStack replacementStack = replacementDefinition.itemStack.func_77946_l();
            replacementStack.func_77964_b(itemStack.func_77952_i());
            this.transferEnchantments(itemStack, replacementStack);
            return replacementStack;
        }
        for (Function function : this.replacementFunctions) {
            ItemStack replacementStack = (ItemStack)function.apply(itemStack);
            if (replacementStack == null) continue;
            return replacementStack;
        }
        return ItemStack.field_190927_a;
    }

    private void transferEnchantments(ItemStack sourceStack, ItemStack modularStack) {
        if (modularStack.func_77973_b() instanceof ItemModular) {
            ItemModular item = (ItemModular)modularStack.func_77973_b();
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)sourceStack);
            for (Map.Entry entry : enchantments.entrySet()) {
                String improvement = instance.getImprovementFromEnchantment((Enchantment)entry.getKey());
                ItemModuleMajor[] modules = (ItemModuleMajor[])Arrays.stream(item.getMajorModules(modularStack)).filter(module -> module.acceptsImprovement(improvement)).toArray(ItemModuleMajor[]::new);
                if (modules.length <= 0) continue;
                float level = 1.0f * (float)((Integer)entry.getValue()).intValue() / (float)modules.length;
                for (int i = 0; i < modules.length; ++i) {
                    if (i == 0) {
                        if (!modules[i].acceptsImprovementLevel(improvement, (int)Math.ceil(level))) continue;
                        modules[i].addImprovement(modularStack, improvement, (int)Math.ceil(level));
                        continue;
                    }
                    if (!modules[i].acceptsImprovementLevel(improvement, (int)level)) continue;
                    modules[i].addImprovement(modularStack, improvement, (int)level);
                }
            }
        }
    }

    public void registerModule(String key, ItemModule module) {
        this.moduleMap.put(key, module);
    }

    public ItemModule getModule(String key) {
        return this.moduleMap.get(key);
    }

    public Collection<ItemModule> getAllModules() {
        return this.moduleMap.values();
    }

    public String getImprovementFromEnchantment(Enchantment enchantment) {
        return Optional.ofNullable(enchantment.getRegistryName()).map(ResourceLocation::func_110623_a).map(path -> "enchantment/" + path).orElse(null);
    }
}

