/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import net.minecraft.item.Item;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.ForgeHooks;
import se.mickelus.tetra.loot.LootEntryOredict;

public class LootEntryDeserializer
implements JsonDeserializer<LootEntry> {
    public LootEntry deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        LootCondition[] conditions;
        int quality;
        int weight;
        JsonObject jsonObject = JsonUtils.func_151210_l((JsonElement)json, (String)"loot item");
        String entryType = JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"type");
        LootEntry ret = ForgeHooks.deserializeJsonLootEntry((String)entryType, (JsonObject)jsonObject, (int)(weight = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"weight", (int)1)), (int)(quality = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"quality", (int)0)), (LootCondition[])(conditions = (LootCondition[])JsonUtils.func_188177_a((JsonObject)jsonObject, (String)"conditions", (Object)new LootCondition[0], (JsonDeserializationContext)context, LootCondition[].class)));
        if (ret != null) {
            return ret;
        }
        try {
            if ("item".equals(entryType)) {
                return this.deserializeItem(jsonObject, context, weight, quality, conditions);
            }
            if ("loot_table".equals(entryType)) {
                return this.deserializeTable(jsonObject, context, weight, quality, conditions);
            }
            if ("empty".equals(entryType)) {
                return LootEntryDeserializer.deserializeEmpty(jsonObject, context, weight, quality, conditions);
            }
            if ("oredict".equals(entryType)) {
                return LootEntryOredict.deserialize(jsonObject, context, weight, quality, conditions);
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getEntryName(JsonObject json, String fallback) {
        if (json.has("entryName")) {
            return JsonUtils.func_151200_h((JsonObject)json, (String)"entryName");
        }
        return fallback;
    }

    private LootEntryItem deserializeItem(JsonObject jsonObject, JsonDeserializationContext context, int weight, int quality, LootCondition[] conditions) {
        String name = LootEntryDeserializer.getEntryName(jsonObject, JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"name"));
        try {
            Item item = JsonUtils.func_188180_i((JsonObject)jsonObject, (String)"name");
            LootFunction[] functions = (LootFunction[])JsonUtils.func_188177_a((JsonObject)jsonObject, (String)"functions", (Object)new LootFunction[0], (JsonDeserializationContext)context, LootFunction[].class);
            return new LootEntryItem(item, weight, quality, functions, conditions, name);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            return null;
        }
    }

    private LootEntryTable deserializeTable(JsonObject jsonObject, JsonDeserializationContext context, int weight, int quality, LootCondition[] conditions) {
        String name = LootEntryDeserializer.getEntryName(jsonObject, JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"name"));
        ResourceLocation resourcelocation = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"name"));
        return new LootEntryTable(resourcelocation, weight, quality, conditions, name);
    }

    public static LootEntryEmpty deserializeEmpty(JsonObject jsonObject, JsonDeserializationContext context, int weight, int quality, LootCondition[] conditions) {
        return new LootEntryEmpty(weight, quality, conditions, LootEntryDeserializer.getEntryName(jsonObject, "empty"));
    }
}

