/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.capabilities.CapabilityHelper;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.module.ItemEffect;

public class FortuneBonusFunction
extends LootFunction {
    private RandomValueRange count;
    private int limit;
    private Capability requiredCapability;
    private int capabilityLevel = -1;

    public FortuneBonusFunction(LootCondition[] conditionsIn, RandomValueRange count, int limit, Capability requiredCapability, int capabilityLevel) {
        super(conditionsIn);
        this.count = count;
        this.limit = limit;
        this.requiredCapability = requiredCapability;
        this.capabilityLevel = capabilityLevel;
    }

    public ItemStack func_186553_a(ItemStack itemStack, Random rand, LootContext context) {
        ItemStack providingStack;
        int fortuneLevel = 0;
        EntityPlayer player = (EntityPlayer)context.func_186495_b();
        if (player != null && this.requiredCapability != null && !(providingStack = CapabilityHelper.getProvidingItemStack(this.requiredCapability, this.capabilityLevel, player)).func_190926_b() && providingStack.func_77973_b() instanceof ItemModular) {
            fortuneLevel = ((ItemModular)providingStack.func_77973_b()).getEffectLevel(providingStack, ItemEffect.fortune);
        }
        itemStack.func_190917_f(Math.round((float)fortuneLevel * this.count.func_186507_b(rand)));
        if (this.limit != 0 && itemStack.func_190916_E() > this.limit) {
            itemStack.func_190920_e(this.limit);
        }
        return itemStack;
    }

    public static class Serializer
    extends LootFunction.Serializer<FortuneBonusFunction> {
        public Serializer() {
            super(new ResourceLocation("tetra:fortune_enchant"), FortuneBonusFunction.class);
        }

        public void serialize(JsonObject json, FortuneBonusFunction object, JsonSerializationContext serializationContext) {
            json.add("count", serializationContext.serialize((Object)object.count));
            json.add("limit", serializationContext.serialize((Object)object.limit));
            json.add("requiredCapability", serializationContext.serialize((Object)object.requiredCapability));
            json.add("capabilityLevel", serializationContext.serialize((Object)object.capabilityLevel));
        }

        public FortuneBonusFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            return new FortuneBonusFunction(conditionsIn, (RandomValueRange)JsonUtils.func_188174_a((JsonObject)object, (String)"count", (JsonDeserializationContext)deserializationContext, RandomValueRange.class), JsonUtils.func_151208_a((JsonObject)object, (String)"limit", (int)0), Capability.valueOf(JsonUtils.func_151200_h((JsonObject)object, (String)"requiredCapability")), JsonUtils.func_151208_a((JsonObject)object, (String)"capabilityLevel", (int)-1));
        }
    }
}

