/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.toolbelt.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import se.mickelus.tetra.gui.GuiAttachment;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.GuiString;
import se.mickelus.tetra.gui.GuiStringOutline;
import se.mickelus.tetra.gui.GuiTexture;
import se.mickelus.tetra.gui.animation.Applier;
import se.mickelus.tetra.gui.animation.KeyframeAnimation;

public class OverlayGuiQuiverSlot
extends GuiElement {
    private static final ResourceLocation texture = new ResourceLocation("tetra", "textures/gui/toolbelt-inventory.png");
    private ItemStack itemStack;
    private Minecraft mc;
    private KeyframeAnimation showAnimation;
    private FontRenderer fontRenderer;
    GuiTexture backdrop;
    GuiString count;
    GuiString hoverLabel;

    public OverlayGuiQuiverSlot(int x, int y, ItemStack itemStack, int slot) {
        super(x, y, 23, 23);
        this.setAttachmentPoint(GuiAttachment.bottomRight);
        this.setAttachmentAnchor(GuiAttachment.bottomRight);
        this.itemStack = itemStack;
        this.mc = Minecraft.func_71410_x();
        if (itemStack != null) {
            this.fontRenderer = itemStack.func_77973_b().getFontRenderer(itemStack);
        }
        if (this.fontRenderer == null) {
            this.fontRenderer = this.mc.field_71466_p;
        }
        this.backdrop = new GuiTexture(0, 0, 23, 23, 32, 28, texture);
        this.addChild(this.backdrop);
        if (itemStack != null) {
            this.count = new GuiStringOutline(-3, 1, itemStack.func_190916_E() + "");
            this.count.setAttachmentPoint(GuiAttachment.middleLeft);
            this.count.setAttachmentAnchor(GuiAttachment.middleRight);
            this.addChild(this.count);
            this.count.setVisible(false);
            this.hoverLabel = new GuiString(-5, 0, itemStack.func_82833_r());
            this.hoverLabel.setAttachmentPoint(GuiAttachment.middleRight);
            this.hoverLabel.setAttachmentAnchor(GuiAttachment.middleLeft);
            this.addChild(this.hoverLabel);
            this.hoverLabel.setVisible(false);
        }
        this.isVisible = false;
        this.showAnimation = new KeyframeAnimation(80, this).applyTo(new Applier.TranslateX(x - 2, x), new Applier.TranslateY(y + 2, y), new Applier.Opacity(0.0f, 1.0f)).withDelay(slot * 80).onStop(finished -> this.count.setVisible(true));
    }

    @Override
    protected void onShow() {
        this.showAnimation.start();
    }

    @Override
    protected boolean onHide() {
        if (this.showAnimation.isActive()) {
            this.showAnimation.stop();
        }
        this.count.setVisible(false);
        this.hoverLabel.setVisible(false);
        return true;
    }

    @Override
    public void draw(int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        super.draw(refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        if (this.opacity == 1.0f) {
            this.drawItemStack(this.itemStack, this.x + refX + 3, this.y + refY + 3);
        }
    }

    private void drawItemStack(ItemStack itemStack, int x, int y) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179126_j();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74520_c();
        this.mc.func_175599_af().func_180450_b(itemStack, x, y);
        this.mc.func_175599_af().func_180453_a(this.fontRenderer, itemStack, x, y, "");
        GlStateManager.func_179097_i();
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    protected void onFocus() {
        this.backdrop.setColor(0xFFFFCC);
        this.hoverLabel.setVisible(true);
    }

    @Override
    protected void onBlur() {
        this.backdrop.setColor(0xFFFFFF);
        this.hoverLabel.setVisible(false);
    }

    @Override
    protected void calculateFocusState(int refX, int refY, int mouseX, int mouseY) {
        boolean gainFocus;
        boolean bl = gainFocus = (mouseX -= refX + this.x) + (mouseY -= refY + this.y) >= 12 && mouseX + mouseY <= 34 && mouseX - mouseY < 10 && mouseY - mouseX < 11;
        if (gainFocus != this.hasFocus) {
            this.hasFocus = gainFocus;
            if (this.hasFocus) {
                this.onFocus();
            } else {
                this.onBlur();
            }
        }
    }
}

