/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.toolbelt.booster;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.items.toolbelt.UtilToolbelt;
import se.mickelus.tetra.items.toolbelt.inventory.InventoryQuickslot;
import se.mickelus.tetra.items.toolbelt.inventory.InventoryStorage;
import se.mickelus.tetra.items.toolbelt.inventory.InventoryToolbelt;
import se.mickelus.tetra.module.ItemEffect;

public class UtilBooster {
    public static final String activeKey = "booster.active";
    public static final String chargedKey = "booster.charged";
    public static final String fuelKey = "booster.fuel";
    public static final String bufferKey = "booster.buffer";
    public static final String cooldownKey = "booster.cooldown";
    public static final int fuelCapacity = 110;
    public static final int fuelCost = 1;
    public static final int fuelCostCharged = 40;
    public static final int fuelRecharge = 1;
    public static final int cooldownTicks = 20;
    public static final int gunpowderGain = 80;
    public static final float boostStrength = 0.035f;
    public static final float chargedBoostStrength = 1.2f;
    public static final float boostLevelMultiplier = 0.4f;

    public static boolean hasBooster(EntityPlayer player) {
        ItemStack itemStack = UtilToolbelt.findToolbelt(player);
        return UtilBooster.canBoost(itemStack);
    }

    public static boolean canBoost(ItemStack itemStack) {
        return UtilBooster.getBoosterLevel(itemStack) > 0;
    }

    public static int getBoosterLevel(ItemStack itemStack) {
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemModular) {
            ItemModular item = (ItemModular)itemStack.func_77973_b();
            return item.getEffectLevel(itemStack, ItemEffect.booster);
        }
        return 0;
    }

    public static boolean hasFuel(NBTTagCompound tag, boolean charged) {
        if (charged) {
            return tag.func_74762_e(fuelKey) >= 40;
        }
        return tag.func_74762_e(fuelKey) >= 1;
    }

    public static int getFuel(NBTTagCompound tag) {
        return tag.func_74762_e(fuelKey);
    }

    public static float getFuelPercent(NBTTagCompound tag) {
        return (float)tag.func_74762_e(fuelKey) * 1.0f / 110.0f;
    }

    public static void boostPlayer(EntityPlayer player, NBTTagCompound tag, int level) {
        float boostBase = 0.035f + 0.035f * (float)(level - 1) * 0.4f;
        if (player.func_184613_cA()) {
            Vec3d vec3d = player.func_70040_Z();
            player.func_70024_g(vec3d.field_72450_a * (double)0.01f + (vec3d.field_72450_a * 1.5 - player.field_70159_w) * (double)0.05f, vec3d.field_72448_b * (double)0.01f + (vec3d.field_72448_b * 1.5 - player.field_70181_x) * (double)0.05f, vec3d.field_72449_c * (double)0.01f + (vec3d.field_72449_c * 1.5 - player.field_70179_y) * (double)0.05f);
        } else if (player.field_70181_x > -0.1) {
            if (player.func_70093_af()) {
                player.func_70024_g(0.0, (double)boostBase / 1.5, 0.0);
            } else {
                player.func_70024_g(0.0, (double)boostBase, 0.0);
            }
            player.field_70143_R = 0.0f;
        } else {
            player.func_70024_g(0.0, (double)boostBase + 0.8 * -player.field_70181_x, 0.0);
        }
        if (player.field_70170_p instanceof WorldServer) {
            ((WorldServer)player.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, player.field_70165_t - 0.2 + Math.random() * 0.4, player.field_70163_u + Math.random() * 0.2, player.field_70161_v - 0.2 + Math.random() * 0.4, 10, 0.0, 0.0, 0.0, 0.1, new int[0]);
        }
    }

    public static void boostPlayerCharged(EntityPlayer player, NBTTagCompound tag, int level) {
        float boostBase = 1.2f + 1.2f * (float)(level - 1) * 0.4f;
        Vec3d lookVector = player.func_70040_Z();
        player.func_70024_g(lookVector.field_72450_a * (double)boostBase, Math.max(lookVector.field_72448_b * (double)boostBase / 2.0, 0.1), lookVector.field_72449_c * (double)boostBase);
        player.field_70133_I = true;
        if (player.field_70170_p instanceof WorldServer) {
            ((WorldServer)player.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_LARGE, player.field_70165_t, player.field_70163_u, player.field_70161_v, 10, 0.0, 0.0, 0.0, 0.1, new int[0]);
            ((WorldServer)player.field_70170_p).func_175739_a(EnumParticleTypes.FLAME, player.field_70165_t, player.field_70163_u, player.field_70161_v, 3, 0.0, 0.0, 0.0, 0.1, new int[0]);
        }
    }

    public static void consumeFuel(NBTTagCompound tag, boolean charged) {
        if (charged) {
            tag.func_74768_a(fuelKey, tag.func_74762_e(fuelKey) - 40);
        } else {
            tag.func_74768_a(fuelKey, tag.func_74762_e(fuelKey) - 1);
        }
        tag.func_74768_a(cooldownKey, 20);
    }

    public static void rechargeFuel(NBTTagCompound tag, ItemStack itemStack) {
        int fuel = tag.func_74762_e(fuelKey);
        int buffer = tag.func_74762_e(bufferKey);
        int cooldown = tag.func_74762_e(cooldownKey);
        if (cooldown > 0) {
            tag.func_74768_a(cooldownKey, cooldown - 1);
        } else if (fuel + 1 < 110) {
            if (buffer > 0) {
                tag.func_74768_a(fuelKey, fuel + 1);
                tag.func_74768_a(bufferKey, buffer - 1);
            } else {
                UtilBooster.refuelBuffer(tag, itemStack);
            }
        }
    }

    private static void refuelBuffer(NBTTagCompound tag, ItemStack itemStack) {
        InventoryToolbelt inventory = new InventoryQuickslot(itemStack);
        int index = inventory.getFirstIndexForItem(Items.field_151016_H);
        if (index != -1) {
            inventory.func_70298_a(index, 1);
            tag.func_74768_a(bufferKey, 80);
            return;
        }
        inventory = new InventoryStorage(itemStack);
        index = inventory.getFirstIndexForItem(Items.field_151016_H);
        if (index != -1) {
            inventory.func_70298_a(index, 1);
            tag.func_74768_a(bufferKey, 80);
            return;
        }
        tag.func_74768_a(cooldownKey, 20);
    }

    public static boolean isActive(NBTTagCompound tag) {
        return tag.func_74767_n(activeKey);
    }

    public static void setActive(NBTTagCompound tag, boolean active, boolean charged) {
        tag.func_74757_a(activeKey, active);
        if (charged) {
            tag.func_74757_a(chargedKey, charged);
        }
    }
}

