/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.toolbelt;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.items.BasicModule;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.items.TetraCreativeTabs;
import se.mickelus.tetra.items.toolbelt.EquipToolbeltItemPacket;
import se.mickelus.tetra.items.toolbelt.GuiHandlerToolbelt;
import se.mickelus.tetra.items.toolbelt.SlotType;
import se.mickelus.tetra.items.toolbelt.ToolbeltModule;
import se.mickelus.tetra.items.toolbelt.booster.JumpHandlerBooster;
import se.mickelus.tetra.items.toolbelt.booster.TickHandlerBooster;
import se.mickelus.tetra.items.toolbelt.booster.UpdateBoosterPacket;
import se.mickelus.tetra.items.toolbelt.inventory.InventoryToolbelt;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.schema.RemoveSchema;
import se.mickelus.tetra.network.GuiHandlerRegistry;
import se.mickelus.tetra.network.PacketHandler;

@Optional.Interface(modid="baubles", iface="baubles.api.IBauble")
public class ItemToolbeltModular
extends ItemModular
implements IBauble {
    private static final String unlocalizedName = "toolbelt_modular";
    @GameRegistry.ObjectHolder(value="tetra:toolbelt_modular")
    public static ItemToolbeltModular instance;
    public static final String slot1Key = "toolbelt/slot1";
    public static final String slot2Key = "toolbelt/slot2";
    public static final String slot3Key = "toolbelt/slot3";
    public static final String beltKey = "toolbelt/belt";
    public static final String slot1Suffix = "_slot1";
    public static final String slot2Suffix = "_slot2";
    public static final String slot3Suffix = "_slot3";
    private ItemModule defaultBelt;
    private ItemModule defaultStrap;

    public ItemToolbeltModular() {
        this.setRegistryName(unlocalizedName);
        this.func_77655_b(unlocalizedName);
        this.func_77625_d(1);
        this.func_77637_a(TetraCreativeTabs.getInstance());
        this.majorModuleKeys = new String[]{slot1Key, slot2Key, slot3Key};
        this.minorModuleKeys = new String[]{beltKey};
        this.requiredModules = new String[]{beltKey};
        this.defaultBelt = new BasicModule(beltKey, beltKey);
        this.defaultStrap = new ToolbeltModule(slot1Key, "strap", slot1Suffix);
        new ToolbeltModule(slot2Key, "strap", slot2Suffix);
        new ToolbeltModule(slot3Key, "strap", slot3Suffix);
        new ToolbeltModule(slot1Key, "potion_storage", slot1Suffix);
        new ToolbeltModule(slot2Key, "potion_storage", slot2Suffix);
        new ToolbeltModule(slot3Key, "potion_storage", slot3Suffix);
        new ToolbeltModule(slot1Key, "storage", slot1Suffix);
        new ToolbeltModule(slot2Key, "storage", slot2Suffix);
        new ToolbeltModule(slot3Key, "storage", slot3Suffix);
        new ToolbeltModule(slot1Key, "quiver", slot1Suffix);
        new ToolbeltModule(slot2Key, "quiver", slot2Suffix);
        new ToolbeltModule(slot3Key, "quiver", slot3Suffix);
        new ToolbeltModule(slot1Key, "booster", slot1Suffix);
        new ToolbeltModule(slot2Key, "booster", slot2Suffix);
        new ToolbeltModule(slot3Key, "booster", slot3Suffix);
    }

    @Override
    public void clientPreInit() {
        super.clientPreInit();
        MinecraftForge.EVENT_BUS.register((Object)new JumpHandlerBooster(Minecraft.func_71410_x()));
    }

    @Override
    public void init(PacketHandler packetHandler) {
        GuiHandlerRegistry.instance.registerHandler(0, new GuiHandlerToolbelt());
        packetHandler.registerPacket(EquipToolbeltItemPacket.class, Side.SERVER);
        packetHandler.registerPacket(UpdateBoosterPacket.class, Side.SERVER);
        MinecraftForge.EVENT_BUS.register((Object)new TickHandlerBooster());
        InventoryToolbelt.initializePredicates();
        ItemUpgradeRegistry.instance.registerConfigSchema(beltKey);
        ItemUpgradeRegistry.instance.registerConfigSchema("toolbelt/strap");
        ItemUpgradeRegistry.instance.registerConfigSchema("toolbelt/strap_improvements");
        ItemUpgradeRegistry.instance.registerConfigSchema("toolbelt/booster");
        ItemUpgradeRegistry.instance.registerConfigSchema("toolbelt/potion_storage");
        ItemUpgradeRegistry.instance.registerConfigSchema("toolbelt/storage");
        ItemUpgradeRegistry.instance.registerConfigSchema("toolbelt/storage_improvements");
        ItemUpgradeRegistry.instance.registerConfigSchema("toolbelt/quiver");
        ItemUpgradeRegistry.instance.registerConfigSchema("toolbelt/quiver_improvements");
        RemoveSchema.registerRemoveSchemas(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTabs, NonNullList<ItemStack> itemList) {
        if (this.func_194125_a(creativeTabs)) {
            itemList.add((Object)this.createDefaultStack());
        }
    }

    private ItemStack createDefaultStack() {
        ItemStack itemStack = new ItemStack((Item)this);
        this.defaultBelt.addModule(itemStack, "belt/rope", null);
        this.defaultStrap.addModule(itemStack, "strap1/leather", null);
        return itemStack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.openGui((Object)TetraMod.instance, 0, world, hand.ordinal(), 0, 0);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public int getNumSlots(ItemStack itemStack, SlotType slotType) {
        return this.getAllModules(itemStack).stream().map(module -> module.getEffectLevel(itemStack, slotType.effect)).reduce(0, Integer::sum);
    }

    public List<Collection<ItemEffect>> getSlotEffects(ItemStack itemStack, SlotType slotType) {
        return this.getAllModules(itemStack).stream().filter(module -> module.getEffects(itemStack).contains((Object)slotType.effect)).map(module -> {
            EnumMap effectLevelMap = new EnumMap(ItemEffect.class);
            module.getEffects(itemStack).stream().filter(itemEffect -> !itemEffect.equals((Object)slotType.effect)).forEach(itemEffect -> effectLevelMap.put((ItemEffect)((Object)((Object)itemEffect)), module.getEffectLevel(itemStack, (ItemEffect)((Object)((Object)itemEffect)))));
            int slotCount = module.getEffectLevel(itemStack, slotType.effect);
            ArrayList result = new ArrayList(slotCount);
            for (int i = 0; i < slotCount; ++i) {
                ArrayList<ItemEffect> slotEffects = new ArrayList<ItemEffect>();
                for (Map.Entry entry : effectLevelMap.entrySet()) {
                    if ((Integer)entry.getValue() <= i) continue;
                    slotEffects.add(entry.getKey());
                }
                result.add(slotEffects);
            }
            return result;
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BELT;
    }
}

