/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.journal.gui.craft;

import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import se.mickelus.tetra.gui.GuiAttachment;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.animation.Applier;
import se.mickelus.tetra.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.items.duplex_tool.ItemDuplexToolModular;
import se.mickelus.tetra.items.journal.gui.craft.GuiJournalItem;
import se.mickelus.tetra.items.sword.ItemSwordModular;
import se.mickelus.tetra.items.toolbelt.ItemToolbeltModular;

public class GuiJournalItems
extends GuiElement {
    private final GuiJournalItem sword;
    private final GuiJournalItem toolbelt;
    private final GuiJournalItem tools;

    public GuiJournalItems(int x, int y, int width, int height, Consumer<ItemModular> onItemSelect, Consumer<String> onSlotSelect) {
        super(x, y, width, height);
        this.sword = new GuiJournalItem(-39, 0, ItemSwordModular.instance, I18n.func_135052_a((String)"journal.craft.sword", (Object[])new Object[0]), () -> onItemSelect.accept(ItemSwordModular.instance), onSlotSelect);
        this.sword.setAttachment(GuiAttachment.topCenter);
        this.addChild(this.sword);
        this.toolbelt = new GuiJournalItem(1, -40, ItemToolbeltModular.instance, I18n.func_135052_a((String)"journal.craft.toolbelt", (Object[])new Object[0]), () -> onItemSelect.accept(ItemToolbeltModular.instance), onSlotSelect);
        this.toolbelt.setAttachment(GuiAttachment.topCenter);
        this.addChild(this.toolbelt);
        this.tools = new GuiJournalItem(41, 0, ItemDuplexToolModular.instance, I18n.func_135052_a((String)"journal.craft.tool", (Object[])new Object[0]), () -> onItemSelect.accept(ItemDuplexToolModular.instance), onSlotSelect);
        this.tools.setAttachment(GuiAttachment.topCenter);
        this.addChild(this.tools);
    }

    public void animateOpen() {
        new KeyframeAnimation(200, this).applyTo(new Applier.TranslateY(this.y - 4, this.y), new Applier.Opacity(0.0f, 1.0f)).withDelay(800).start();
    }

    public void animateBack() {
        new KeyframeAnimation(100, this).applyTo(new Applier.TranslateY(this.y - 4, this.y), new Applier.Opacity(0.0f, 1.0f)).start();
    }

    public void changeItem(Item item) {
        if (item instanceof ItemSwordModular) {
            this.toolbelt.setVisible(false);
            this.tools.setVisible(false);
            this.sword.setVisible(true);
            this.sword.setSelected(true);
        } else if (item instanceof ItemToolbeltModular) {
            this.sword.setVisible(false);
            this.tools.setVisible(false);
            this.toolbelt.setVisible(true);
            this.toolbelt.setSelected(true);
        } else if (item instanceof ItemDuplexToolModular) {
            this.sword.setVisible(false);
            this.toolbelt.setVisible(false);
            this.tools.setVisible(true);
            this.tools.setSelected(true);
        } else {
            this.sword.setSelected(false);
            this.toolbelt.setSelected(false);
            this.tools.setSelected(false);
            this.sword.setVisible(true);
            this.toolbelt.setVisible(true);
            this.tools.setVisible(true);
        }
    }
}

