/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.journal.gui.craft;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import se.mickelus.tetra.gui.GuiAttachment;
import se.mickelus.tetra.gui.GuiClickable;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.GuiStringOutline;
import se.mickelus.tetra.gui.GuiTexture;
import se.mickelus.tetra.gui.animation.Applier;
import se.mickelus.tetra.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.impl.GuiModuleOffsets;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.items.journal.gui.craft.GuiJournalSlot;
import se.mickelus.tetra.items.journal.gui.craft.GuiJournalSlotMajor;

public class GuiJournalItem
extends GuiClickable {
    private static final String WORKBENCH_TEXTURE = "textures/gui/workbench.png";
    GuiElement slotGroup;
    private List<KeyframeAnimation> selectAnimations = new ArrayList<KeyframeAnimation>();
    private List<KeyframeAnimation> deselectAnimations = new ArrayList<KeyframeAnimation>();
    private KeyframeAnimation itemShow;
    private KeyframeAnimation itemHide;
    private boolean isSelected = false;
    private final GuiTexture backdrop = new GuiTexture(0, 0, 52, 52, "textures/gui/workbench.png");

    public GuiJournalItem(int x, int y, ItemModular item, String label, Runnable onSelect, Consumer<String> onSlotSelect) {
        super(x, y, 64, 64, onSelect);
        this.backdrop.setAttachment(GuiAttachment.middleCenter);
        this.addChild(this.backdrop);
        GuiStringOutline labelString = new GuiStringOutline(0, -1, label);
        labelString.setAttachment(GuiAttachment.middleCenter);
        this.addChild(labelString);
        this.selectAnimations.add(new KeyframeAnimation(80, labelString).applyTo(new Applier.Opacity(0.0f)));
        this.deselectAnimations.add(new KeyframeAnimation(80, labelString).applyTo(new Applier.Opacity(1.0f)));
        this.slotGroup = new GuiElement(37, 15, 0, 0);
        this.setupSlots(item, onSlotSelect);
        this.slotGroup.setVisible(false);
        this.addChild(this.slotGroup);
        this.selectAnimations.add(new KeyframeAnimation(80, this.slotGroup).applyTo(new Applier.Opacity(1.0f)));
        this.deselectAnimations.add(new KeyframeAnimation(80, this.slotGroup).applyTo(new Applier.Opacity(0.0f)).onStop(complete -> {
            if (complete.booleanValue()) {
                this.slotGroup.setVisible(false);
            }
        }));
        this.selectAnimations.add(new KeyframeAnimation(80, this).applyTo(new Applier.TranslateX(0.0f), new Applier.TranslateY(0.0f)));
        this.deselectAnimations.add(new KeyframeAnimation(80, this).applyTo(new Applier.TranslateX(x), new Applier.TranslateY(y)));
        this.itemShow = new KeyframeAnimation(80, this).applyTo(new Applier.Opacity(1.0f));
        this.itemHide = new KeyframeAnimation(80, this).applyTo(new Applier.Opacity(0.0f)).onStop(complete -> {
            this.isVisible = false;
        });
    }

    @Override
    public boolean onClick(int x, int y) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (!((GuiElement)((Object)this.elements.get(i))).isVisible() || !((GuiElement)((Object)this.elements.get(i))).onClick(x, y)) continue;
            return true;
        }
        return super.onClick(x, y);
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.deselectAnimations.forEach(KeyframeAnimation::stop);
            this.slotGroup.setVisible(true);
            this.selectAnimations.forEach(KeyframeAnimation::start);
        } else {
            this.selectAnimations.forEach(KeyframeAnimation::stop);
            this.deselectAnimations.forEach(KeyframeAnimation::start);
        }
        this.backdrop.setColor(0xFFFFFF);
        this.isSelected = selected;
    }

    @Override
    protected void onShow() {
        super.onShow();
        this.itemHide.stop();
        this.itemShow.start();
    }

    @Override
    protected boolean onHide() {
        super.onHide();
        this.itemShow.stop();
        this.itemHide.start();
        return false;
    }

    @Override
    protected void calculateFocusState(int refX, int refY, int mouseX, int mouseY) {
        boolean gainFocus = true;
        if ((mouseX -= refX + this.x) + (mouseY -= refY + this.y) < 44) {
            gainFocus = false;
        }
        if (mouseX + mouseY > 84) {
            gainFocus = false;
        }
        if (mouseX - mouseY > 16) {
            gainFocus = false;
        }
        if (mouseY - mouseX > 19) {
            gainFocus = false;
        }
        if (gainFocus != this.hasFocus) {
            this.hasFocus = gainFocus;
            if (this.hasFocus) {
                this.onFocus();
            } else {
                this.onBlur();
            }
        }
    }

    @Override
    protected void onFocus() {
        if (!this.isSelected) {
            this.backdrop.setColor(0xFFFFCC);
        }
    }

    @Override
    protected void onBlur() {
        this.backdrop.setColor(0xFFFFFF);
    }

    private void setupSlots(ItemModular item, Consumer<String> onSlotSelect) {
        GuiAttachment attachment;
        int x;
        int i;
        String[] majorModuleNames = item.getMajorModuleNames();
        String[] majorModuleKeys = item.getMajorModuleKeys();
        GuiModuleOffsets majorOffsets = GuiModuleOffsets.getMajorOffsets(item);
        String[] minorModuleNames = item.getMinorModuleNames();
        String[] minorModuleKeys = item.getMinorModuleKeys();
        GuiModuleOffsets minorOffsets = GuiModuleOffsets.getMinorOffsets(item);
        for (i = 0; i < majorModuleNames.length; ++i) {
            x = majorOffsets.getX(i);
            attachment = x > 0 ? GuiAttachment.topLeft : GuiAttachment.topRight;
            this.slotGroup.addChild(new GuiJournalSlotMajor(x, majorOffsets.getY(i), attachment, majorModuleKeys[i], majorModuleNames[i], onSlotSelect));
        }
        for (i = 0; i < minorModuleNames.length; ++i) {
            x = minorOffsets.getX(i);
            attachment = x > 0 ? GuiAttachment.topLeft : GuiAttachment.topRight;
            this.slotGroup.addChild(new GuiJournalSlot(x, minorOffsets.getY(i), attachment, minorModuleKeys[i], minorModuleNames[i], onSlotSelect));
        }
    }
}

