/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.journal.gui.craft;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import se.mickelus.tetra.gui.GuiAttachment;
import se.mickelus.tetra.gui.GuiButton;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.GuiString;
import se.mickelus.tetra.gui.animation.Applier;
import se.mickelus.tetra.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.impl.GuiKeybinding;

public class GuiJournalBreadcrumbs
extends GuiElement {
    private Consumer<Integer> onClick;
    private KeyframeAnimation openAnimation;
    private KeyframeAnimation showAnimation;
    private KeyframeAnimation hideAnimation;
    private KeyframeAnimation focusAnimation;
    private KeyframeAnimation blurAnimation;
    private List<GuiElement> separators;
    private List<GuiButton> buttons;

    public GuiJournalBreadcrumbs(int x, int y, int width, Consumer<Integer> onClick) {
        super(x, y, width, 16);
        this.onClick = onClick;
        this.openAnimation = new KeyframeAnimation(80, this).applyTo(new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(x - 5, x)).withDelay(80);
        this.showAnimation = new KeyframeAnimation(80, this).applyTo(new Applier.Opacity(1.0f), new Applier.TranslateX(x));
        this.hideAnimation = new KeyframeAnimation(80, this).applyTo(new Applier.Opacity(0.0f), new Applier.TranslateX(x - 5)).onStop(complete -> {
            this.isVisible = false;
        });
        this.separators = new ArrayList<GuiElement>();
        this.buttons = new ArrayList<GuiButton>();
        GuiKeybinding keybinding = new GuiKeybinding(0, 3, "q");
        keybinding.setAttachmentPoint(GuiAttachment.topRight);
        keybinding.setOpacity(0.0f);
        this.addChild(keybinding);
        this.focusAnimation = new KeyframeAnimation(80, keybinding).applyTo(new Applier.Opacity(1.0f), new Applier.TranslateX(keybinding.getX() - 5));
        this.blurAnimation = new KeyframeAnimation(80, keybinding).applyTo(new Applier.Opacity(0.0f), new Applier.TranslateX(keybinding.getX()));
    }

    public void setItems(String[] items) {
        String label;
        int i;
        int xOffset = 0;
        int overlapCount = Math.min(this.buttons.size(), items.length);
        for (i = 0; i < overlapCount; ++i) {
            label = !"".equals(items[i]) ? items[i] : I18n.func_135052_a((String)"journal.craft.slot", (Object[])new Object[0]);
            GuiButton button = this.buttons.get(i);
            button.setText(label);
            button.setX(xOffset);
            if (i != 0) {
                this.separators.get(i - 1).setX(xOffset - 8);
            }
            xOffset = button.getX() + button.getWidth() + 12;
        }
        for (i = this.buttons.size(); i > items.length; --i) {
            this.removeButton(i - 1);
        }
        for (i = this.buttons.size(); i < items.length; ++i) {
            label = !"".equals(items[i]) ? items[i] : I18n.func_135052_a((String)"journal.craft.slot", (Object[])new Object[0]);
            this.addbutton(i, label);
        }
        if (!this.buttons.isEmpty()) {
            GuiButton button = this.buttons.get(this.buttons.size() - 1);
            this.setWidth(button.getX() + button.getWidth());
        }
    }

    private void addbutton(int index, String label) {
        int xOffset = 0;
        if (!this.buttons.isEmpty()) {
            GuiElement last = this.buttons.get(this.buttons.size() - 1);
            xOffset = last.getX() + last.getWidth() + 12;
        }
        GuiButton button = new GuiButton(xOffset, 4, label, () -> this.onClick.accept(index));
        new KeyframeAnimation(80, button).applyTo(new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(xOffset - 2, xOffset)).withDelay(40).start();
        this.buttons.add(button);
        this.addChild(button);
        if (index != 0) {
            GuiString separator = new GuiString(xOffset - 8, 5, ">", 0x7F7F7F);
            new KeyframeAnimation(80, separator).applyTo(new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateX(xOffset - 10, xOffset - 8)).start();
            this.separators.add(separator);
            this.addChild(separator);
        }
    }

    private void removeButton(int index) {
        GuiElement button = this.buttons.remove(index);
        new KeyframeAnimation(80, button).applyTo(new Applier.Opacity(0.0f), new Applier.TranslateX(button.getX() - 2)).onStop(finished -> button.remove()).start();
        if (index > 0) {
            GuiElement separator = this.separators.remove(index - 1);
            new KeyframeAnimation(80, separator).applyTo(new Applier.Opacity(0.0f), new Applier.TranslateX(separator.getX() - 2)).withDelay(40).onStop(finished -> separator.remove()).start();
        }
    }

    public void animateOpen(boolean fast) {
        this.openAnimation.withDelay(fast ? 80 : 600).start();
    }

    @Override
    protected void onShow() {
        super.onShow();
        this.hideAnimation.stop();
        this.showAnimation.start();
    }

    @Override
    protected boolean onHide() {
        super.onHide();
        this.showAnimation.stop();
        this.hideAnimation.start();
        return false;
    }

    @Override
    protected void onFocus() {
        this.blurAnimation.stop();
        this.focusAnimation.start();
    }

    @Override
    protected void onBlur() {
        this.focusAnimation.stop();
        this.blurAnimation.start();
    }
}

