/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.journal.gui;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.items.journal.GuiJournalRootBase;
import se.mickelus.tetra.items.journal.JournalPage;
import se.mickelus.tetra.items.journal.gui.GuiJournalHeader;
import se.mickelus.tetra.items.journal.gui.blueprint.GuiJournalBlueprintRoot;
import se.mickelus.tetra.items.journal.gui.craft.GuiJournalCraftRoot;
import se.mickelus.tetra.items.journal.gui.system.GuiJournalSystemRoot;

@SideOnly(value=Side.CLIENT)
public class GuiJournal
extends GuiScreen {
    private final GuiJournalHeader header;
    private final GuiJournalRootBase[] pages;
    private GuiJournalRootBase currentPage;
    private GuiElement defaultGui;
    private static GuiJournal instance;

    public GuiJournal() {
        this.field_146291_p = false;
        this.field_146294_l = 320;
        this.field_146295_m = 240;
        this.field_146289_q = Minecraft.func_71410_x().field_71466_p;
        this.defaultGui = new GuiElement(0, 0, this.field_146294_l, this.field_146295_m);
        this.header = new GuiJournalHeader(0, 0, this.field_146294_l, this::changePage);
        this.defaultGui.addChild(this.header);
        this.pages = new GuiJournalRootBase[JournalPage.values().length];
        this.pages[0] = new GuiJournalCraftRoot(0, 18);
        this.defaultGui.addChild(this.pages[0]);
        this.pages[1] = new GuiJournalBlueprintRoot(0, 18);
        this.pages[1].setVisible(false);
        this.defaultGui.addChild(this.pages[1]);
        this.pages[2] = new GuiJournalSystemRoot(0, 18);
        this.pages[2].setVisible(false);
        this.defaultGui.addChild(this.pages[2]);
        this.currentPage = this.pages[0];
    }

    public static GuiJournal getInstance() {
        if (instance == null || ConfigHandler.development) {
            instance = new GuiJournal();
        }
        return instance;
    }

    public void onShow() {
        this.header.onShow();
        this.currentPage.animateOpen();
    }

    private void changePage(JournalPage page) {
        this.header.changePage(page);
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i].setVisible(page.ordinal() == i);
        }
        this.currentPage = this.pages[page.ordinal()];
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.defaultGui.draw((this.field_146294_l - this.defaultGui.getWidth()) / 2, (this.field_146295_m - this.defaultGui.getHeight()) / 2, this.field_146294_l, this.field_146295_m, mouseX, mouseY, 1.0f);
        this.renderHoveredToolTip(mouseX, mouseY);
    }

    protected void renderHoveredToolTip(int mouseX, int mouseY) {
        List<String> tooltipLines = this.defaultGui.getTooltipLines();
        if (tooltipLines != null) {
            tooltipLines = tooltipLines.stream().map(line -> line.replace("\\n", "\n")).flatMap(line -> Arrays.stream(line.split("\n"))).collect(Collectors.toList());
            GuiUtils.drawHoveringText(tooltipLines, (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)300, (FontRenderer)this.field_146289_q);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.defaultGui.onClick(mouseX, mouseY);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.currentPage.onKeyTyped(typedChar);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }
}

