/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.duplex_tool;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.blocks.workbench.BlockWorkbench;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.data.DataHandler;
import se.mickelus.tetra.items.BasicMajorModule;
import se.mickelus.tetra.items.BasicModule;
import se.mickelus.tetra.items.ItemModularHandheld;
import se.mickelus.tetra.items.TetraCreativeTabs;
import se.mickelus.tetra.items.duplex_tool.DuplexHeadModule;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.Priority;
import se.mickelus.tetra.module.schema.BookEnchantSchema;
import se.mickelus.tetra.module.schema.RemoveSchema;
import se.mickelus.tetra.module.schema.RepairSchema;
import se.mickelus.tetra.network.PacketHandler;

public class ItemDuplexToolModular
extends ItemModularHandheld {
    public static final String headLeftKey = "duplex/head_left";
    public static final String headRightKey = "duplex/head_right";
    public static final String handleKey = "duplex/handle";
    public static final String bindingKey = "duplex/binding";
    public static final String accessoryKey = "duplex/accessory";
    public static final String leftSuffix = "_left";
    public static final String rightSuffix = "_right";
    private static final String unlocalizedName = "duplex_tool_modular";
    public static DuplexHeadModule basicHammerHeadLeft;
    public static DuplexHeadModule basicHammerHeadRight;
    public static DuplexHeadModule basicAxeLeft;
    public static DuplexHeadModule basicAxeRight;
    public static DuplexHeadModule basicPickaxeLeft;
    public static DuplexHeadModule basicPickaxeRight;
    public static DuplexHeadModule hoeLeft;
    public static DuplexHeadModule hoeRight;
    public static DuplexHeadModule adzeLeft;
    public static DuplexHeadModule adzeRight;
    public static DuplexHeadModule sickleLeft;
    public static DuplexHeadModule sickleRight;
    public static DuplexHeadModule clawLeft;
    public static DuplexHeadModule clawRight;
    public static DuplexHeadModule butt;
    public static BasicMajorModule handle;
    @GameRegistry.ObjectHolder(value="tetra:duplex_tool_modular")
    public static ItemDuplexToolModular instance;

    public ItemDuplexToolModular() {
        this.func_77655_b(unlocalizedName);
        this.setRegistryName(unlocalizedName);
        this.func_77625_d(1);
        this.func_77637_a(TetraCreativeTabs.getInstance());
        this.entityHitDamage = 2;
        this.majorModuleKeys = new String[]{headLeftKey, headRightKey, handleKey};
        this.minorModuleKeys = new String[]{bindingKey};
        this.requiredModules = new String[]{handleKey, headLeftKey, headRightKey};
        this.synergies = DataHandler.instance.getSynergyData("modules/duplex/synergies");
        basicHammerHeadLeft = new DuplexHeadModule(headLeftKey, "basic_hammer", leftSuffix, "duplex/improvements/basic_hammer", "duplex/improvements/shared_head_hone", "settling_improvements", "destabilization_improvements");
        basicHammerHeadRight = new DuplexHeadModule(headRightKey, "basic_hammer", rightSuffix, "duplex/improvements/basic_hammer", "duplex/improvements/shared_head_hone", "settling_improvements", "destabilization_improvements");
        basicAxeLeft = new DuplexHeadModule(headLeftKey, "basic_axe", leftSuffix, "duplex/improvements/basic_axe", "duplex/improvements/basic_axe_hone", "duplex/improvements/shared_head_hone", "settling_improvements", "destabilization_improvements");
        basicAxeRight = new DuplexHeadModule(headRightKey, "basic_axe", rightSuffix, "duplex/improvements/basic_axe", "duplex/improvements/basic_axe_hone", "duplex/improvements/shared_head_hone", "settling_improvements", "destabilization_improvements");
        basicPickaxeLeft = new DuplexHeadModule(headLeftKey, "basic_pickaxe", leftSuffix, "duplex/improvements/basic_pickaxe", "duplex/improvements/basic_pickaxe_hone", "duplex/improvements/shared_head_hone", "settling_improvements", "destabilization_improvements");
        basicPickaxeRight = new DuplexHeadModule(headRightKey, "basic_pickaxe", rightSuffix, "duplex/improvements/basic_pickaxe", "duplex/improvements/basic_pickaxe_hone", "duplex/improvements/shared_head_hone", "settling_improvements", "destabilization_improvements");
        hoeLeft = new DuplexHeadModule(headLeftKey, "hoe", leftSuffix, "duplex/improvements/hoe", "duplex/improvements/hoe_hone", "duplex/improvements/shared_head_hone", "settling_improvements", "destabilization_improvements");
        hoeRight = new DuplexHeadModule(headRightKey, "hoe", rightSuffix, "duplex/improvements/hoe", "duplex/improvements/hoe_hone", "duplex/improvements/shared_head_hone", "settling_improvements", "destabilization_improvements");
        adzeLeft = new DuplexHeadModule(headLeftKey, "adze", leftSuffix, "duplex/improvements/adze", "duplex/improvements/adze_hone", "duplex/improvements/shared_head_hone", "settling_improvements", "destabilization_improvements");
        adzeRight = new DuplexHeadModule(headRightKey, "adze", rightSuffix, "duplex/improvements/adze", "duplex/improvements/adze_hone", "duplex/improvements/shared_head_hone", "settling_improvements", "destabilization_improvements");
        sickleLeft = new DuplexHeadModule(headLeftKey, "sickle", leftSuffix, "duplex/improvements/sickle", "duplex/improvements/sickle_hone", "duplex/improvements/shared_head_hone", "settling_improvements", "destabilization_improvements");
        sickleRight = new DuplexHeadModule(headRightKey, "sickle", rightSuffix, "duplex/improvements/sickle", "duplex/improvements/sickle_hone", "duplex/improvements/shared_head_hone", "settling_improvements", "destabilization_improvements");
        clawLeft = new DuplexHeadModule(headLeftKey, "claw", leftSuffix, "duplex/improvements/claw", "duplex/improvements/claw_hone", "duplex/improvements/shared_head_hone", "settling_improvements", "destabilization_improvements");
        clawRight = new DuplexHeadModule(headRightKey, "claw", rightSuffix, "duplex/improvements/claw", "duplex/improvements/claw_hone", "duplex/improvements/shared_head_hone", "settling_improvements", "destabilization_improvements");
        butt = new DuplexHeadModule(headRightKey, "butt", rightSuffix, "duplex/improvements/butt", "duplex/improvements/butt_hone", "duplex/improvements/shared_head_hone", "settling_improvements", "destabilization_improvements");
        handle = new BasicMajorModule(handleKey, "duplex/basic_handle", "duplex/improvements/basic_handle", "duplex/improvements/basic_handle_hone", "duplex/improvements/shared_head_hone", "settling_improvements", "destabilization_improvements").withRenderLayer(Priority.LOWER);
        new BasicModule(bindingKey, bindingKey, "duplex/tweaks/binding");
        new BasicModule(bindingKey, "duplex/socket");
        this.updateConfig(ConfigHandler.honeDuplexBase, ConfigHandler.honeDuplexIntegrityMultiplier);
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    @Override
    public void init(PacketHandler packetHandler) {
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/basic_hammer");
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/basic_hammer_hone");
        new BookEnchantSchema(basicHammerHeadLeft);
        new BookEnchantSchema(basicHammerHeadRight);
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/basic_axe");
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/basic_axe_hone");
        new BookEnchantSchema(basicAxeLeft);
        new BookEnchantSchema(basicAxeRight);
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/basic_pickaxe");
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/basic_pickaxe_hone");
        new BookEnchantSchema(basicPickaxeLeft);
        new BookEnchantSchema(basicPickaxeRight);
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/hoe");
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/hoe_hone");
        new BookEnchantSchema(hoeLeft);
        new BookEnchantSchema(hoeRight);
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/adze");
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/adze_hone");
        new BookEnchantSchema(adzeLeft);
        new BookEnchantSchema(adzeRight);
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/sickle");
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/sickle_hone");
        new BookEnchantSchema(sickleLeft);
        new BookEnchantSchema(sickleRight);
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/claw");
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/claw_hone");
        new BookEnchantSchema(clawLeft);
        new BookEnchantSchema(clawRight);
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/butt");
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/butt_hone");
        new BookEnchantSchema(butt);
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/basic_handle");
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/basic_handle_hone");
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/basic_handle_improvements");
        new BookEnchantSchema(handle);
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/shared_head_hone");
        new RepairSchema(this);
        RemoveSchema.registerRemoveSchemas(this);
        ItemUpgradeRegistry.instance.registerReplacementDefinition("axe");
        ItemUpgradeRegistry.instance.registerReplacementDefinition("pickaxe");
        ItemUpgradeRegistry.instance.registerReplacementDefinition("hoe");
        ItemUpgradeRegistry.instance.registerConfigSchema(bindingKey);
        ItemUpgradeRegistry.instance.registerConfigSchema("duplex/socket");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTabs, NonNullList<ItemStack> itemList) {
        if (this.func_194125_a(creativeTabs)) {
            itemList.add((Object)this.createHammerStack("log", "stick"));
            itemList.add((Object)this.createHammerStack("obsidian", "iron"));
        }
    }

    public ItemStack createHammerStack(String headMaterial, String handleMaterial) {
        ItemStack itemStack = new ItemStack((Item)this);
        basicHammerHeadLeft.addModule(itemStack, "basic_hammer/" + headMaterial, null);
        basicHammerHeadRight.addModule(itemStack, "basic_hammer/" + headMaterial, null);
        handle.addModule(itemStack, "basic_handle/" + handleMaterial, null);
        return itemStack;
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public ImmutableList<ResourceLocation> getTextures(ItemStack itemStack) {
        return super.getTextures(itemStack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!player.func_70093_af() && world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150462_ai) && this.getCapabilityLevel(player.func_184586_b(hand), Capability.hammer) > 0) {
            return BlockWorkbench.upgradeWorkbench(player, world, pos, hand, side);
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    @Override
    protected String getDisplayNamePrefixes(ItemStack itemStack) {
        String modulePrefix = Optional.ofNullable(this.getModuleFromSlot(itemStack, headLeftKey)).map(module -> module.getItemPrefix(itemStack)).map(prefix -> prefix + " ").orElse("");
        return Arrays.stream(this.getImprovements(itemStack)).map(improvement -> improvement.key + ".prefix").filter(I18n::func_188566_a).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])).findFirst().map(prefix -> prefix + " " + modulePrefix).orElse(modulePrefix);
    }

    @Override
    public double getDamageModifier(ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return 0.0;
        }
        double damageModifier = Stream.of(this.getModuleFromSlot(itemStack, headLeftKey), this.getModuleFromSlot(itemStack, headRightKey)).filter(Objects::nonNull).mapToDouble(module -> module.getDamageModifier(itemStack)).max().orElse(0.0);
        damageModifier = this.getAllModules(itemStack).stream().filter(itemModule -> !headLeftKey.equals(itemModule.getSlot()) && !headRightKey.equals(itemModule.getSlot())).map(itemModule -> itemModule.getDamageModifier(itemStack)).reduce(damageModifier, Double::sum);
        damageModifier = Arrays.stream(this.getSynergyData(itemStack)).mapToDouble(synergyData -> synergyData.damage).reduce(damageModifier, Double::sum);
        damageModifier = Arrays.stream(this.getSynergyData(itemStack)).mapToDouble(synergyData -> synergyData.damageMultiplier).reduce(damageModifier, (a, b) -> a * b);
        return this.getAllModules(itemStack).stream().map(itemModule -> itemModule.getDamageMultiplierModifier(itemStack)).reduce(damageModifier, (a, b) -> a * b);
    }
}

