/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.cell;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import se.mickelus.tetra.items.TetraCreativeTabs;
import se.mickelus.tetra.items.TetraItem;

public class ItemCellMagmatic
extends TetraItem {
    private static final String unlocalizedName = "magmatic_cell";
    @GameRegistry.ObjectHolder(value="tetra:magmatic_cell")
    public static ItemCellMagmatic instance;
    private final String chargedPropKey = "tetra:charged";
    public static final int maxCharge = 128;

    public ItemCellMagmatic() {
        this.setRegistryName(unlocalizedName);
        this.func_77655_b(unlocalizedName);
        this.func_77637_a(TetraCreativeTabs.getInstance());
        this.func_77656_e(128);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("tetra:charged"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack itemStack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemCellMagmatic.this.getCharge(itemStack) > 0 ? 1.0f : 0.0f;
            }
        });
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int charge = this.getCharge(stack);
        if (charge == 128) {
            tooltip.add(I18n.func_135052_a((String)"item.magmatic_cell.charge", (Object[])new Object[]{I18n.func_135052_a((String)"item.magmatic_cell.charge_full", (Object[])new Object[0])}));
        } else if ((double)charge > 51.2) {
            tooltip.add(I18n.func_135052_a((String)"item.magmatic_cell.charge", (Object[])new Object[]{I18n.func_135052_a((String)"item.magmatic_cell.charge_good", (Object[])new Object[0])}));
        } else if (charge > 0) {
            tooltip.add(I18n.func_135052_a((String)"item.magmatic_cell.charge", (Object[])new Object[]{I18n.func_135052_a((String)"item.magmatic_cell.charge_low", (Object[])new Object[0])}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"item.magmatic_cell.charge", (Object[])new Object[]{I18n.func_135052_a((String)"item.magmatic_cell.charge_empty", (Object[])new Object[0])}));
        }
        tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"forged_description", (Object[])new Object[0]));
    }

    public void func_150895_a(CreativeTabs creativeTabs, NonNullList<ItemStack> itemList) {
        if (this.func_194125_a(creativeTabs)) {
            itemList.add((Object)new ItemStack((Item)this));
            ItemStack emptyStack = new ItemStack((Item)this);
            emptyStack.func_77964_b(128);
            itemList.add((Object)emptyStack);
        }
    }

    public int getCharge(ItemStack itemStack) {
        return itemStack.func_77958_k() - itemStack.func_77952_i();
    }

    public int drainCharge(ItemStack itemStack, int amount) {
        if (itemStack.func_77952_i() + amount < itemStack.func_77958_k()) {
            this.setDamage(itemStack, itemStack.func_77952_i() + amount);
            return amount;
        }
        int actualAmount = itemStack.func_77958_k() - itemStack.func_77952_i();
        this.setDamage(itemStack, itemStack.func_77958_k());
        return actualAmount;
    }

    public int recharge(ItemStack itemStack, int amount) {
        if (this.getDamage(itemStack) - amount >= 0) {
            this.setDamage(itemStack, this.getDamage(itemStack) - amount);
            return 0;
        }
        int overfill = amount - this.getDamage(itemStack);
        this.setDamage(itemStack, 0);
        return overfill;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return super.getDurabilityForDisplay(itemStack);
    }

    public int getRGBDurabilityForDisplay(ItemStack itemStack) {
        return super.getRGBDurabilityForDisplay(itemStack);
    }
}

