/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.oredict.OreDictionary;
import se.mickelus.tetra.NBTHelper;
import se.mickelus.tetra.PotionBleeding;
import se.mickelus.tetra.PotionEarthbound;
import se.mickelus.tetra.blocks.workbench.BlockWorkbench;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.module.ItemEffectHandler;
import se.mickelus.tetra.util.CastOptional;

public class ItemModularHandheld
extends ItemModular {
    private static final Set<Block> axeBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP, Blocks.field_150440_ba, Blocks.field_150468_ap, Blocks.field_150471_bO, Blocks.field_150452_aw});
    private static final Set<Material> axeMaterials = Sets.newHashSet((Object[])new Material[]{Material.field_151575_d});
    private static final Set<Block> pickaxeBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150408_cc, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_150334_T, Blocks.field_150318_D, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150439_ay, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_150333_U, Blocks.field_150430_aB, Blocks.field_150456_au});
    private static final Set<Material> pickaxeMaterials = Sets.newHashSet((Object[])new Material[]{Material.field_151573_f, Material.field_151574_g, Material.field_151576_e});
    private static final Set<Block> shovelBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_150458_ak, Blocks.field_150349_c, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150425_aM, Blocks.field_185774_da, Blocks.field_192444_dS});
    private static final Set<Material> cuttingMaterials = Sets.newHashSet((Object[])new Material[]{Material.field_151585_k, Material.field_151582_l, Material.field_151589_v, Material.field_151584_j, Material.field_151572_C, Material.field_151569_G, Material.field_151580_n});
    private static final String[] denailOreDict = new String[]{"plankWood", "slabWood", "stairWood", "fenceWood", "fenceGateWood", "doorWood", "chestWood"};
    private static final List<Predicate<IBlockState>> denailBlocks = ImmutableList.of((Object)BlockMatcher.func_177642_a((Block)Blocks.field_150462_ai), (Object)BlockStateMatcher.func_177638_a((Block)BlockWorkbench.instance).func_177637_a(BlockWorkbench.propVariant, Predicates.equalTo((Object)((Object)BlockWorkbench.Variant.wood))), (Object)BlockMatcher.func_177642_a((Block)Blocks.field_150342_X), (Object)BlockMatcher.func_177642_a((Block)Blocks.field_150447_bR), (Object)BlockMatcher.func_177642_a((Block)Blocks.field_150448_aq), (Object)BlockMatcher.func_177642_a((Block)Blocks.field_150408_cc), (Object)BlockMatcher.func_177642_a((Block)Blocks.field_150319_E), (Object)BlockMatcher.func_177642_a((Block)Blocks.field_150318_D), (Object)BlockMatcher.func_177642_a((Block)Blocks.field_150472_an), (Object)BlockMatcher.func_177642_a((Block)Blocks.field_150444_as), (Object)BlockMatcher.func_177642_a((Block)Blocks.field_150324_C), (Object)BlockMatcher.func_177642_a((Block)Blocks.field_150468_ap), (Object[])new Predicate[]{BlockMatcher.func_177642_a((Block)Blocks.field_150421_aI), BlockMatcher.func_177642_a((Block)Blocks.field_150323_B), BlockMatcher.func_177642_a((Block)Blocks.field_150415_aT), BlockMatcher.func_177642_a((Block)Blocks.field_150452_aw), BlockMatcher.func_177642_a((Block)Blocks.field_150471_bO), BlockMatcher.func_177642_a((Block)Blocks.field_150453_bW), BlockMatcher.func_177642_a((Block)Blocks.field_180402_cm)});
    protected static final UUID ARMOR_MODIFIER = UUID.fromString("D96050BE-6A94-4A27-AA0B-2AF705327BA4");
    protected int blockDestroyDamage = 1;
    protected int entityHitDamage = 1;

    public boolean func_179218_a(ItemStack itemStack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
        int xp;
        int intuitLevel;
        if (state.func_185887_b(world, pos) > 0.0f) {
            this.applyDamage(this.blockDestroyDamage, itemStack, entity);
            if (!this.isBroken(itemStack)) {
                this.tickProgression(entity, itemStack, 1);
            }
        }
        if (!world.field_72995_K && (intuitLevel = this.getEffectLevel(itemStack, ItemEffect.intuit)) > 0 && (xp = state.func_177230_c().getExpDrop(state, (IBlockAccess)world, pos, this.getEffectLevel(itemStack, ItemEffect.fortune))) > 0) {
            this.tickHoningProgression(entity, itemStack, xp);
        }
        this.causeFierySelfEffect(entity, itemStack, 1.0);
        this.causeEnderReverbEffect(entity, itemStack, 1.0);
        this.causeHauntEffect(entity, itemStack, 1.0);
        return true;
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase target, EntityLivingBase attacker) {
        this.applyDamage(this.entityHitDamage, itemStack, attacker);
        if (!this.isBroken(itemStack)) {
            int earthbindLevel;
            int arthropodLevel;
            int bleedingLevel;
            int sweepingLevel;
            int knockbackLevel;
            this.getAllModules(itemStack).forEach(module -> module.hitEntity(itemStack, target, attacker));
            int fieryLevel = this.getEffectLevel(itemStack, ItemEffect.fiery);
            if (fieryLevel > 0) {
                target.func_70015_d(fieryLevel * 4);
            }
            if ((knockbackLevel = this.getEffectLevel(itemStack, ItemEffect.knockback)) > 0) {
                target.func_70653_a((Entity)attacker, (float)knockbackLevel * 0.5f, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)))));
            }
            if ((sweepingLevel = this.getEffectLevel(itemStack, ItemEffect.sweeping)) > 0) {
                this.sweepAttack(itemStack, target, attacker, sweepingLevel, knockbackLevel);
            }
            if ((bleedingLevel = this.getEffectLevel(itemStack, ItemEffect.bleeding)) > 0 && !EnumCreatureAttribute.UNDEAD.equals((Object)target.func_70668_bt()) && attacker.func_70681_au().nextFloat() < 0.3f) {
                target.func_70690_d(new PotionEffect((Potion)PotionBleeding.instance, 40, bleedingLevel));
            }
            if ((arthropodLevel = this.getEffectLevel(itemStack, ItemEffect.arthropod)) > 0 && EnumCreatureAttribute.ARTHROPOD.equals((Object)target.func_70668_bt())) {
                int ticks = 20 + attacker.func_70681_au().nextInt(10 * arthropodLevel);
                target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, ticks, 3));
            }
            if ((earthbindLevel = this.getEffectLevel(itemStack, ItemEffect.earthbind)) > 0 && (double)attacker.func_70681_au().nextFloat() < Math.max(0.1, 0.5 * (1.0 - target.field_70163_u / 128.0))) {
                target.func_70690_d(new PotionEffect((Potion)PotionEarthbound.instance, 80, 0, false, true));
                if (target.field_70170_p instanceof WorldServer) {
                    ((WorldServer)target.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_CRACK, target.field_70165_t, target.field_70163_u + 0.1, target.field_70161_v, 16, 0.0, 0.1, 0.0, target.field_70170_p.field_73012_v.nextGaussian() * 0.2, new int[]{Block.func_176210_f((IBlockState)target.field_70170_p.func_180495_p(new BlockPos(target.field_70165_t, target.field_70163_u - 1.0, target.field_70161_v)))});
                }
            }
            this.causeFierySelfEffect(attacker, itemStack, 1.4);
            this.causeEnderReverbEffect(attacker, itemStack, 1.5);
            this.causeHauntEffect(attacker, itemStack, 1.5);
            this.tickProgression(attacker, itemStack, 1);
        }
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = player.func_184586_b(hand);
        int flatteningLevel = this.getEffectLevel(itemStack, ItemEffect.flattening);
        int tillingLevel = this.getEffectLevel(itemStack, ItemEffect.tilling);
        this.causeFierySelfEffect((EntityLivingBase)player, itemStack, 2.0);
        this.causeEnderReverbEffect((EntityLivingBase)player, itemStack, 1.7);
        if (flatteningLevel > 0 && (tillingLevel > 0 && player.func_70093_af() || tillingLevel == 0)) {
            return this.flattenPath(player, world, pos, hand, facing);
        }
        if (tillingLevel > 0) {
            return this.tillBlock(player, world, pos, hand, facing);
        }
        int denailingLevel = this.getEffectLevel(itemStack, ItemEffect.denailing);
        if (denailingLevel > 0 && (double)player.func_184825_o(0.0f) > 0.9) {
            EnumActionResult result = this.denailBlock(player, world, pos, hand, facing);
            if (result.equals((Object)EnumActionResult.SUCCESS)) {
                player.func_184821_cY();
            }
            return result;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    protected void causeFierySelfEffect(EntityLivingBase entity, ItemStack itemStack, double multiplier) {
        double fierySelfEfficiency;
        if (!entity.field_70170_p.field_72995_K && (fierySelfEfficiency = this.getEffectEfficiency(itemStack, ItemEffect.fierySelf)) > 0.0) {
            BlockPos pos = entity.func_180425_c();
            float temperature = entity.field_70170_p.func_180494_b(pos).func_180626_a(pos);
            if (entity.func_70681_au().nextDouble() < fierySelfEfficiency * (double)temperature * multiplier) {
                entity.func_70015_d(this.getEffectLevel(itemStack, ItemEffect.fierySelf));
            }
        }
    }

    protected void causeEnderReverbEffect(EntityLivingBase entity, ItemStack itemStack, double multiplier) {
        AxisAlignedBB aabb;
        List nearbyTargets;
        double effectProbability;
        if (!entity.field_70170_p.field_72995_K && (effectProbability = this.getEffectEfficiency(itemStack, ItemEffect.enderReverb)) > 0.0 && entity.func_70681_au().nextDouble() < effectProbability * multiplier && (nearbyTargets = entity.field_70170_p.func_175647_a(EntityLivingBase.class, aabb = new AxisAlignedBB(entity.func_180425_c()).func_186662_g(24.0), target -> target instanceof EntityEnderman || target instanceof EntityEndermite || target instanceof EntityShulker || target instanceof EntityDragon)).size() > 0) {
            ((EntityLivingBase)nearbyTargets.get(entity.func_70681_au().nextInt(nearbyTargets.size()))).func_70604_c(entity);
        }
    }

    protected void causeHauntEffect(EntityLivingBase entity, ItemStack itemStack, double multiplier) {
        double effectProbability;
        if (!entity.field_70170_p.field_72995_K && (effectProbability = this.getEffectEfficiency(itemStack, ItemEffect.haunted)) > 0.0 && entity.func_70681_au().nextDouble() < effectProbability * multiplier) {
            int effectLevel = this.getEffectLevel(itemStack, ItemEffect.haunted);
            EntityVex vex = new EntityVex(entity.field_70170_p);
            vex.func_190653_a(effectLevel * 20);
            vex.func_70012_b(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v, entity.field_70177_z, 0.0f);
            vex.func_184611_a(EnumHand.MAIN_HAND, itemStack.func_77946_l());
            vex.func_184174_b(true);
            vex.func_184642_a(EntityEquipmentSlot.MAINHAND, 1.0f);
            vex.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 2000 + effectLevel * 20));
            entity.field_70170_p.func_72838_d((Entity)vex);
            CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).map(item -> Arrays.stream(item.getMajorModules(itemStack))).orElse(Stream.empty()).filter(Objects::nonNull).filter(module -> module.getImprovement(itemStack, "destabilized/haunted") != null).findAny().ifPresent(module -> {
                int level = module.getImprovementLevel(itemStack, "destabilized/haunted");
                if (level > 0) {
                    module.addImprovement(itemStack, "destabilized/haunted", level - 1);
                } else {
                    module.removeImprovement(itemStack, "destabilized/haunted");
                }
            });
            entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187920_gt, SoundCategory.PLAYERS, 2.0f, 2.0f);
        }
    }

    public EnumActionResult flattenPath(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemStack)) {
            return EnumActionResult.FAIL;
        }
        if (facing != EnumFacing.DOWN && world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && world.func_180495_p(pos).func_177230_c() == Blocks.field_150349_c) {
            world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(pos, Blocks.field_185774_da.func_176223_P(), 11);
                this.applyDamage(this.blockDestroyDamage, itemStack, (EntityLivingBase)player);
                this.tickProgression((EntityLivingBase)player, itemStack, this.blockDestroyDamage);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult tillBlock(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemStack)) {
            return EnumActionResult.FAIL;
        }
        UseHoeEvent event = new UseHoeEvent(player, itemStack, world, pos);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return EnumActionResult.FAIL;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            this.applyDamage(this.blockDestroyDamage, itemStack, (EntityLivingBase)player);
            this.tickProgression((EntityLivingBase)player, itemStack, this.blockDestroyDamage);
            return EnumActionResult.SUCCESS;
        }
        IBlockState currentState = world.func_180495_p(pos);
        Block block = currentState.func_177230_c();
        if (facing != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
            IBlockState newState = null;
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da || block == Blocks.field_150346_d && BlockDirt.DirtType.DIRT == currentState.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                newState = Blocks.field_150458_ak.func_176223_P();
            } else if (block == Blocks.field_150346_d && BlockDirt.DirtType.COARSE_DIRT == currentState.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                newState = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT);
            }
            if (newState != null) {
                world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, newState, 11);
                    this.applyDamage(this.blockDestroyDamage, itemStack, (EntityLivingBase)player);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult denailBlock(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing) {
        boolean success;
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemStack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState blockState = world.func_180495_p(pos);
        if (this.canDenail(blockState, world, pos) && (success = ItemEffectHandler.breakBlock(world, player, player.func_184586_b(hand), pos, blockState))) {
            this.applyDamage(this.blockDestroyDamage, itemStack, (EntityLivingBase)player);
            this.tickProgression((EntityLivingBase)player, itemStack, this.blockDestroyDamage);
            world.func_180498_a(player, 2001, pos, Block.func_176210_f((IBlockState)blockState));
            player.func_184821_cY();
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private boolean canDenail(IBlockState blockState, World world, BlockPos pos) {
        boolean matchOre = Optional.of(blockState.func_177230_c().getPickBlock(blockState, null, world, pos, null)).map(OreDictionary::getOreIDs).map(Stream::of).orElseGet(Stream::empty).flatMapToInt(Arrays::stream).mapToObj(OreDictionary::getOreName).anyMatch(ore1 -> Arrays.asList(denailOreDict).contains(ore1));
        if (matchOre) {
            return true;
        }
        return denailBlocks.stream().anyMatch(predicate -> predicate.test(blockState));
    }

    private void sweepAttack(ItemStack itemStack, EntityLivingBase target, EntityLivingBase attacker, int sweepingLevel, int knockbackLevel) {
        float cooldown = 1.0f;
        if (attacker instanceof EntityPlayer) {
            cooldown = ItemModularHandheld.getCooledAttackStrength(itemStack);
        }
        if ((double)cooldown > 0.9) {
            float damage = (float)Math.max((this.getDamageModifier(itemStack) + 1.0) * (double)((float)sweepingLevel * 0.125f), 1.0);
            float knockback = sweepingLevel > 4 ? (float)(knockbackLevel + 1) * 0.5f : 0.5f;
            double range = 1.0 + this.getEffectEfficiency(itemStack, ItemEffect.sweeping);
            attacker.field_70170_p.func_72872_a(EntityLivingBase.class, target.func_174813_aQ().func_72314_b(range, 0.25, range)).stream().filter(entity -> entity != attacker).filter(entity -> !attacker.func_184191_r((Entity)entity)).filter(entity -> attacker.func_70068_e((Entity)entity) < (range + 2.0) * (range + 2.0)).forEach(entity -> {
                entity.func_70653_a((Entity)attacker, knockback, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)))));
                if (attacker instanceof EntityPlayer) {
                    entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), damage);
                } else {
                    entity.func_70097_a(DamageSource.func_188403_a((Entity)attacker, (EntityLivingBase)entity), damage);
                }
            });
            attacker.field_70170_p.func_184148_a(null, attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v, SoundEvents.field_187730_dW, attacker.func_184176_by(), 1.0f, 1.0f);
            ItemModularHandheld.spawnSweepParticles(attacker);
        }
    }

    public static void spawnSweepParticles(World world, double x, double y, double z, double xOffset, double zOffset) {
        if (world instanceof WorldServer) {
            ((WorldServer)world).func_175739_a(EnumParticleTypes.SWEEP_ATTACK, x, y, z, 1, xOffset, 0.0, zOffset, 0.0, new int[0]);
        }
    }

    public static void spawnSweepParticles(EntityLivingBase attacker) {
        double xOffset = -MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180)));
        double zOffset = MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)));
        ItemModularHandheld.spawnSweepParticles(attacker.field_70170_p, attacker.field_70165_t + xOffset, attacker.field_70163_u + (double)attacker.field_70131_O * 0.5, attacker.field_70161_v + zOffset, xOffset, zOffset);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        this.setCooledAttackStrength(stack, player.func_184825_o(0.5f));
        return false;
    }

    public void setCooledAttackStrength(ItemStack itemStack, float strength) {
        NBTHelper.getTag(itemStack).func_74776_a("cooledStrength", strength);
    }

    public static float getCooledAttackStrength(ItemStack itemStack) {
        return NBTHelper.getTag(itemStack).func_74760_g("cooledStrength");
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack itemStack) {
        int armor;
        Multimap multimap = super.getAttributeModifiers(slot, itemStack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.getDamageModifier(itemStack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.getSpeedModifier(itemStack), 0));
        }
        if ((slot == EntityEquipmentSlot.MAINHAND || slot == EntityEquipmentSlot.OFFHAND) && (armor = this.getEffectLevel(itemStack, ItemEffect.armor)) > 0) {
            multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIER, "Weapon modifier", (double)armor, 0));
        }
        return multimap;
    }

    public double getDamageModifier(ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return 0.0;
        }
        double damageModifier = this.getAllModules(itemStack).stream().mapToDouble(itemModule -> itemModule.getDamageModifier(itemStack)).sum();
        damageModifier = Arrays.stream(this.getSynergyData(itemStack)).mapToDouble(synergyData -> synergyData.damage).reduce(damageModifier, Double::sum);
        damageModifier = Arrays.stream(this.getSynergyData(itemStack)).mapToDouble(synergyData -> synergyData.damageMultiplier).reduce(damageModifier, (a, b) -> a * b);
        return this.getAllModules(itemStack).stream().map(itemModule -> itemModule.getDamageMultiplierModifier(itemStack)).reduce(damageModifier, (a, b) -> a * b);
    }

    public static double getDamageModifierStatic(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemModularHandheld) {
            return ((ItemModularHandheld)itemStack.func_77973_b()).getDamageModifier(itemStack);
        }
        return 0.0;
    }

    public double getSpeedModifier(ItemStack itemStack) {
        double speedModifier = this.getAllModules(itemStack).stream().map(itemModule -> itemModule.getSpeedModifier(itemStack)).reduce(-2.4, Double::sum);
        speedModifier = Arrays.stream(this.getSynergyData(itemStack)).mapToDouble(synergyData -> synergyData.attackSpeed).reduce(speedModifier, Double::sum);
        speedModifier = Arrays.stream(this.getSynergyData(itemStack)).mapToDouble(synergyData -> synergyData.attackSpeedMultiplier).reduce(speedModifier, (a, b) -> a * b);
        speedModifier = this.getAllModules(itemStack).stream().map(itemModule -> itemModule.getSpeedMultiplierModifier(itemStack)).reduce(speedModifier, (a, b) -> a * b);
        if ((speedModifier *= this.getCounterWeightMultiplier(itemStack)) < -4.0) {
            speedModifier = -3.9;
        }
        return speedModifier;
    }

    public double getCounterWeightMultiplier(ItemStack itemStack) {
        int counterWeightLevel = this.getEffectLevel(itemStack, ItemEffect.counterweight);
        if (counterWeightLevel > 0) {
            int integrityCost = ItemModularHandheld.getIntegrityCost(itemStack);
            return 0.5 + (double)Math.abs(counterWeightLevel + integrityCost) * 0.2;
        }
        return 1.0;
    }

    public static double getSpeedModifierStatic(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemModularHandheld) {
            return ((ItemModularHandheld)itemStack.func_77973_b()).getSpeedModifier(itemStack);
        }
        return 2.0;
    }

    public Set<String> getToolClasses(ItemStack itemStack) {
        if (!this.isBroken(itemStack)) {
            return this.getCapabilities(itemStack).stream().map(Enum::toString).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public int getHarvestLevel(ItemStack itemStack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        int capabilityLevel;
        if (!this.isBroken(itemStack) && (capabilityLevel = this.getCapabilityLevel(itemStack, toolClass)) > 0) {
            return capabilityLevel - 1;
        }
        return -1;
    }

    public boolean canHarvestBlock(IBlockState blockState, ItemStack itemStack) {
        if (pickaxeMaterials.contains(blockState.func_185904_a())) {
            return this.getHarvestLevel(itemStack, "pickaxe", null, null) >= 0;
        }
        if (blockState.func_177230_c().equals(Blocks.field_150321_G)) {
            return this.getHarvestLevel(itemStack, "cut", null, null) >= 0;
        }
        return false;
    }

    public float func_150893_a(ItemStack itemStack, IBlockState blockState) {
        if (!this.isBroken(itemStack)) {
            String tool = ItemModularHandheld.getEffectiveTool(blockState);
            float speed = (float)(4.0 + this.getSpeedModifier(itemStack)) * this.getCapabilityEfficiency(itemStack, tool);
            if ("cut".equals(tool) && blockState.func_177230_c().equals(Blocks.field_150321_G)) {
                speed *= 10.0f;
            }
            if (speed < 1.0f) {
                return 1.0f;
            }
            return speed;
        }
        return 1.0f;
    }

    public static String getEffectiveTool(IBlockState blockState) {
        String tool = blockState.func_177230_c().getHarvestTool(blockState);
        if (tool != null) {
            return tool;
        }
        if (axeMaterials.contains(blockState.func_185904_a())) {
            return "axe";
        }
        if (pickaxeMaterials.contains(blockState.func_185904_a())) {
            return "pickaxe";
        }
        if (axeBlocks.contains(blockState.func_177230_c())) {
            return "axe";
        }
        if (pickaxeBlocks.contains(blockState.func_177230_c())) {
            return "pickaxe";
        }
        if (cuttingMaterials.contains(blockState.func_185904_a())) {
            return "cut";
        }
        if (shovelBlocks.contains(blockState.func_177230_c())) {
            return "shovel";
        }
        return null;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    @Override
    public ItemStack onCraftConsumeCapability(ItemStack providerStack, ItemStack targetStack, EntityPlayer player, Capability capability, int capabilityLevel, boolean consumeResources) {
        if (consumeResources) {
            this.applyDamage(capabilityLevel, providerStack, (EntityLivingBase)player);
            this.causeFierySelfEffect((EntityLivingBase)player, providerStack, capabilityLevel * 2);
            this.causeEnderReverbEffect((EntityLivingBase)player, providerStack, capabilityLevel * 2);
            this.causeHauntEffect((EntityLivingBase)player, providerStack, capabilityLevel * 2);
            this.tickProgression((EntityLivingBase)player, providerStack, capabilityLevel * 2);
        }
        return super.onCraftConsumeCapability(providerStack, targetStack, player, capability, capabilityLevel, consumeResources);
    }

    @Override
    public ItemStack onActionConsumeCapability(ItemStack providerStack, ItemStack targetStack, EntityPlayer player, Capability capability, int capabilityLevel, boolean consumeResources) {
        if (consumeResources) {
            this.applyDamage(capabilityLevel, providerStack, (EntityLivingBase)player);
            this.causeFierySelfEffect((EntityLivingBase)player, providerStack, capabilityLevel * 2);
            this.causeEnderReverbEffect((EntityLivingBase)player, providerStack, capabilityLevel * 2);
            this.causeHauntEffect((EntityLivingBase)player, providerStack, capabilityLevel * 2);
            this.tickProgression((EntityLivingBase)player, providerStack, capabilityLevel * 2);
        }
        return super.onCraftConsumeCapability(providerStack, targetStack, player, capability, capabilityLevel, consumeResources);
    }

    @Override
    public void assemble(ItemStack itemStack, World world) {
        super.assemble(itemStack, world);
        NBTTagCompound nbt = NBTHelper.getTag(itemStack);
        nbt.func_82580_o("ench");
        nbt.func_74768_a("HideFlags", 1);
        if (this.getEffects(itemStack).contains((Object)ItemEffect.silkTouch)) {
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            enchantments.put(Enchantments.field_185306_r, 1);
            EnchantmentHelper.func_82782_a(enchantments, (ItemStack)itemStack);
        }
    }
}

