/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.impl.statbar.getter;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.gui.impl.statbar.getter.IStatGetter;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.util.CastOptional;

public class StatGetterEffectLevel
implements IStatGetter {
    private ItemEffect effect;
    private double multiplier;
    private double base;

    public StatGetterEffectLevel(ItemEffect effect, double multiplier) {
        this(effect, multiplier, 0.0);
    }

    public StatGetterEffectLevel(ItemEffect effect, double multiplier, double base) {
        this.effect = effect;
        this.multiplier = multiplier;
        this.base = base;
    }

    @Override
    public double getValue(EntityPlayer player, ItemStack itemStack) {
        return this.base + CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).map(item -> (double)item.getEffectLevel(itemStack, this.effect) * this.multiplier).orElse(0.0);
    }

    @Override
    public double getValue(EntityPlayer player, ItemStack itemStack, String slot) {
        return CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).map(item -> item.getModuleFromSlot(itemStack, slot)).map(module -> (double)module.getEffectLevel(itemStack, this.effect) * this.multiplier).orElse(0.0);
    }

    @Override
    public double getValue(EntityPlayer player, ItemStack itemStack, String slot, String improvement) {
        return this.base + CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).flatMap(item -> CastOptional.cast(item.getModuleFromSlot(itemStack, slot), ItemModuleMajor.class)).map(module -> module.getImprovement(itemStack, improvement)).map(improvementData -> (double)improvementData.effects.getLevel(this.effect) * this.multiplier).orElse(0.0);
    }
}

