/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.impl.statbar.getter;

import com.mojang.realmsclient.gui.ChatFormatting;
import se.mickelus.tetra.gui.impl.statbar.getter.ILabelGetter;

public class LabelGetterBasic
implements ILabelGetter {
    protected static final String increaseColorFont = ChatFormatting.GREEN.toString();
    protected static final String decreaseColorFont = ChatFormatting.RED.toString();
    protected String formatDiff;
    protected String formatDiffFlipped;
    protected String format;
    public static final ILabelGetter integerLabel = new LabelGetterBasic("%.0f", "%+.0f");
    public static final ILabelGetter decimalLabel = new LabelGetterBasic("%.02f", "%+.02f");
    public static final ILabelGetter percentageLabel = new LabelGetterBasic("%.0f%%", "%+.0f%%");
    public static final ILabelGetter percentageLabelDecimal = new LabelGetterBasic("%.01f%%", "%+.01f%%");

    public LabelGetterBasic(String format) {
        this(format, format);
    }

    public LabelGetterBasic(String format, String formatDiff) {
        this.formatDiff = "%s(" + formatDiff + ") %s" + format;
        this.formatDiffFlipped = format + " %s(" + formatDiff + ")";
        this.format = format;
    }

    @Override
    public String getLabel(double value, double diffValue, boolean flipped) {
        if (value != diffValue) {
            if (flipped) {
                return String.format(this.formatDiffFlipped, diffValue, value < diffValue ? increaseColorFont : decreaseColorFont, diffValue - value);
            }
            return String.format(this.formatDiff, value < diffValue ? increaseColorFont : decreaseColorFont, diffValue - value, ChatFormatting.RESET, diffValue);
        }
        return String.format(this.format, diffValue);
    }
}

