/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.impl.statbar;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.blocks.workbench.gui.GuiCapability;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.gui.GuiAlignment;
import se.mickelus.tetra.gui.impl.statbar.GuiStatBar;
import se.mickelus.tetra.gui.impl.statbar.getter.IStatGetter;
import se.mickelus.tetra.gui.impl.statbar.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.impl.statbar.getter.StatGetterCapabilityEfficiency;
import se.mickelus.tetra.gui.impl.statbar.getter.StatGetterCapabilityLevel;
import se.mickelus.tetra.gui.impl.statbar.getter.TooltipGetterCapability;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.util.CastOptional;

public class GuiStatBarCapability
extends GuiStatBar {
    private static final int efficiencyMax = 50;
    private GuiCapability capabilityElement;
    private IStatGetter levelGetter;

    public GuiStatBarCapability(int x, int y, int width, Capability capability) {
        super(x, y, width, "", 0.0, 50.0, false, new StatGetterCapabilityEfficiency(capability), LabelGetterBasic.decimalLabel, new TooltipGetterCapability(capability));
        this.bar.setWidth(width - 16);
        this.bar.setX(16);
        this.levelGetter = new StatGetterCapabilityLevel(capability);
        this.capabilityElement = new GuiCapability(-3, -3, capability);
        this.addChild(this.capabilityElement);
    }

    @Override
    public void update(EntityPlayer player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        super.update(player, currentStack, previewStack, slot, improvement);
        int level = (int)this.levelGetter.getValue(player, currentStack);
        int color = 0xFFFFFF;
        if (!previewStack.func_190926_b()) {
            int previewLevel = (int)this.levelGetter.getValue(player, previewStack);
            color = this.getDiffColor(level, previewLevel);
            level = previewLevel;
        } else if (slot != null) {
            int previewLevel = level - this.getSlotLevel(player, currentStack, slot, improvement);
            color = this.getDiffColor(previewLevel, level);
        }
        this.capabilityElement.update(level, color);
    }

    @Override
    protected void realign() {
        super.realign();
        if (GuiAlignment.left.equals((Object)this.alignment)) {
            this.bar.setX(16);
            this.capabilityElement.setX(-3);
        } else {
            this.bar.setX(0);
            this.capabilityElement.setX(0);
        }
        this.capabilityElement.setAttachment(this.alignment.toAttachment());
    }

    @Override
    public boolean shouldShow(EntityPlayer player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        return this.levelGetter.getValue(player, currentStack) > 0.0 || this.levelGetter.getValue(player, previewStack) > 0.0;
    }

    protected int getDiffColor(int currentValue, int previewValue) {
        if (previewValue > currentValue) {
            return 0x55FF55;
        }
        if (previewValue < currentValue) {
            return 0xFF5555;
        }
        return 0xFFFFFF;
    }

    protected int getSlotLevel(EntityPlayer player, ItemStack itemStack, String slot, String improvement) {
        return CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).map(item -> {
            if (improvement != null) {
                return this.levelGetter.getValue(player, itemStack, slot, improvement);
            }
            return this.levelGetter.getValue(player, itemStack, slot);
        }).orElse(-1.0).intValue();
    }
}

