/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.impl.statbar;

import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.gui.GuiAlignment;
import se.mickelus.tetra.gui.GuiString;
import se.mickelus.tetra.gui.GuiStringSmall;
import se.mickelus.tetra.gui.impl.statbar.GuiBar;
import se.mickelus.tetra.gui.impl.statbar.GuiBarSegmented;
import se.mickelus.tetra.gui.impl.statbar.GuiBarSplit;
import se.mickelus.tetra.gui.impl.statbar.GuiStatBase;
import se.mickelus.tetra.gui.impl.statbar.getter.ILabelGetter;
import se.mickelus.tetra.gui.impl.statbar.getter.IStatGetter;
import se.mickelus.tetra.gui.impl.statbar.getter.ITooltipGetter;
import se.mickelus.tetra.items.ItemModular;
import se.mickelus.tetra.util.CastOptional;

public class GuiStatBar
extends GuiStatBase {
    protected double min;
    protected double max;
    protected GuiString labelString;
    protected GuiString valueString;
    protected GuiBar bar;
    protected List<String> tooltip;
    protected GuiAlignment alignment = GuiAlignment.left;
    protected IStatGetter statGetter;
    protected ILabelGetter labelGetter;
    protected ITooltipGetter tooltipGetter;

    public GuiStatBar(int x, int y, int barLength, String label, double min, double max, boolean segmented, IStatGetter statGetter, ILabelGetter labelGetter, ITooltipGetter tooltipGetter) {
        this(x, y, barLength, label, min, max, segmented, false, statGetter, labelGetter, tooltipGetter);
    }

    public GuiStatBar(int x, int y, int barLength, String label, double min, double max, boolean segmented, boolean split, IStatGetter statGetter, ILabelGetter labelGetter, ITooltipGetter tooltipGetter) {
        super(x, y, barLength, 12);
        this.min = min;
        this.max = max;
        this.labelString = new GuiStringSmall(0, 0, label);
        this.valueString = new GuiStringSmall(0, 0, label);
        this.bar = segmented ? new GuiBarSegmented(0, 0, barLength + 1, min, max) : (split ? new GuiBarSplit(0, 0, barLength, max) : new GuiBar(0, 0, barLength, min, max));
        this.addChild(this.labelString);
        this.addChild(this.valueString);
        this.addChild(this.bar);
        this.statGetter = statGetter;
        this.labelGetter = labelGetter;
        this.tooltipGetter = tooltipGetter;
    }

    @Override
    public void setAlignment(GuiAlignment alignment) {
        this.alignment = alignment;
        this.realign();
    }

    protected void realign() {
        this.bar.setAlignment(this.alignment);
        this.labelString.setAttachment(this.alignment.toAttachment());
        this.valueString.setAttachment(this.alignment.toAttachment().flipHorizontal());
    }

    @Override
    public void update(EntityPlayer player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        double diffValue;
        double value;
        if (!previewStack.func_190926_b()) {
            value = this.statGetter.getValue(player, currentStack);
            diffValue = this.statGetter.getValue(player, previewStack);
            this.tooltip = Collections.singletonList(this.tooltipGetter.getTooltip(player, previewStack));
        } else {
            value = this.statGetter.getValue(player, currentStack);
            if (slot != null) {
                diffValue = value;
                value -= this.getSlotValue(player, currentStack, slot, improvement);
            } else {
                diffValue = value;
            }
            this.tooltip = Collections.singletonList(this.tooltipGetter.getTooltip(player, currentStack));
        }
        this.updateValue(value, diffValue);
    }

    @Override
    public boolean shouldShow(EntityPlayer player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        return this.statGetter.shouldShow(player, currentStack, previewStack);
    }

    protected double getSlotValue(EntityPlayer player, ItemStack itemStack, String slot, String improvement) {
        return CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).map(item -> {
            if (improvement != null) {
                return this.statGetter.getValue(player, itemStack, slot, improvement);
            }
            return this.statGetter.getValue(player, itemStack, slot);
        }).orElse(0.0);
    }

    public void updateValue(double value, double diffValue) {
        this.bar.setValue(value, diffValue);
        this.updateValueLabel(value, diffValue);
    }

    private void updateValueLabel(double value, double diffValue) {
        this.valueString.setString(this.labelGetter.getLabel(value, diffValue, this.alignment == GuiAlignment.right));
    }

    @Override
    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltip;
        }
        return super.getTooltipLines();
    }
}

