/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.impl;

import java.util.function.Consumer;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.impl.GuiTabVerticalButton;

public class GuiTabVerticalGroup
extends GuiElement {
    private static final char[] keybindings = new char[]{'a', 's', 'd', 'f', 'g'};
    private GuiTabVerticalButton[] buttons;
    private Consumer<Integer> clickHandler;

    public GuiTabVerticalGroup(int x, int y, Consumer<Integer> clickHandler, String ... labels) {
        super(x, y, 3, labels.length * 16 + 1);
        this.buttons = new GuiTabVerticalButton[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            int index = i;
            this.buttons[i] = new GuiTabVerticalButton(1, 1 + 16 * i, labels[i], i < keybindings.length ? keybindings[i] + "" : null, () -> {
                clickHandler.accept(index);
                this.setActive(index);
            }, i == 0);
            this.addChild(this.buttons[i]);
        }
        this.clickHandler = clickHandler;
    }

    public void setActive(int index) {
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setActive(i == index);
        }
    }

    public void setHasContent(int index, boolean hasContent) {
        this.buttons[index].setHasContent(hasContent);
    }

    public void keyTyped(char typedChar) {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (i >= keybindings.length || keybindings[i] != typedChar) continue;
            this.setActive(i);
            this.clickHandler.accept(i);
        }
    }
}

