/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.generation;

import java.util.Arrays;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.BlockRotationProcessor;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.server.FMLServerHandler;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.RotationHelper;
import se.mickelus.tetra.data.DataHandler;
import se.mickelus.tetra.generation.GenerationFeature;
import se.mickelus.tetra.generation.processor.CompoundProcessor;
import se.mickelus.tetra.generation.processor.ForgedContainerProcessor;
import se.mickelus.tetra.generation.processor.ForgedCrateProcessor;
import se.mickelus.tetra.generation.processor.HammerProcessor;
import se.mickelus.tetra.generation.processor.TransferUnitProcessor;

public class WorldGenFeatures
implements IWorldGenerator {
    GenerationFeature[] features = DataHandler.instance.getGenerationFeatures();
    TemplateManager templateManager;
    public static WorldGenFeatures instance;

    public WorldGenFeatures() {
        DataFixer dataFixer = FMLCommonHandler.instance().getEffectiveSide().equals((Object)Side.CLIENT) ? Minecraft.func_71410_x().func_184126_aj() : FMLServerHandler.instance().getServer().getDataFixer();
        this.templateManager = new TemplateManager("tetra", dataFixer);
        if (ConfigHandler.development) {
            new Timer("featureReload").schedule(new TimerTask(){

                @Override
                public void run() {
                    GenerationFeature[] features = DataHandler.instance.getGenerationFeatures();
                    Minecraft.func_71410_x().func_152343_a(() -> {
                        WorldGenFeatures.instance.features = features;
                        return features;
                    });
                }
            }, 0L, 1000L);
        }
        instance = this;
    }

    public GenerationFeature getFeature(String name) {
        return Arrays.stream(this.features).filter(feature -> feature.location.func_110623_a().equals(name)).findFirst().orElse(null);
    }

    public GenerationFeature getFeature(ResourceLocation location) {
        return Arrays.stream(this.features).filter(feature -> feature.location.equals((Object)location)).findFirst().orElse(null);
    }

    public GenerationFeature[] getFeatures() {
        return this.features;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        Arrays.stream(this.features).filter(feature -> Arrays.stream(feature.dimensions).anyMatch(id -> world.field_73011_w.getDimension() == id)).filter(feature -> {
            Biome biome = world.func_180494_b(new BlockPos(chunkX * 16, 0, chunkZ * 16));
            Set types = BiomeDictionary.getTypes((Biome)biome);
            return types.stream().anyMatch(type -> Arrays.stream(feature.biomes).anyMatch(biomeName -> biomeName.equals(type.getName().toLowerCase())));
        }).filter(feature -> random.nextFloat() < feature.probability).forEach(feature -> this.generateFeatureRoot((GenerationFeature)feature, chunkX, chunkZ, world, random));
    }

    public void generateFeatureRoot(GenerationFeature feature, int chunkX, int chunkZ, World world, Random random) {
        BlockPos blockPos = new BlockPos(chunkX * 16 + 1, feature.minY, chunkZ * 16 + 1);
        if (feature.maxY > feature.minY) {
            blockPos = blockPos.func_177982_a(0, random.nextInt(feature.maxY - feature.minY), 0);
        }
        Rotation rotation = Rotation.NONE;
        Mirror mirror = Mirror.NONE;
        if (feature.transform) {
            rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        }
        this.generateFeature(feature, world, blockPos, rotation, mirror, random, 0);
    }

    private void generateFeature(GenerationFeature feature, World world, BlockPos pos, Rotation rotation, Mirror mirror, Random random, int depth) {
        Template template = this.templateManager.func_186237_a(world.func_73046_m(), feature.location);
        PlacementSettings settings = new PlacementSettings();
        settings.func_186220_a(rotation);
        settings.func_189950_a(random);
        settings.func_189946_a(random.nextFloat() * (feature.integrityMax - feature.integrityMin) + feature.integrityMin);
        if (depth == 0) {
            pos = template.func_189961_a(pos, mirror, rotation);
            pos = this.adjustRootPosition(feature, world, pos, rotation);
        }
        CompoundProcessor processors = new CompoundProcessor(new ITemplateProcessor[]{new BlockRotationProcessor(pos, settings), new HammerProcessor(settings.func_189947_a(pos)), new ForgedCrateProcessor(settings.func_189947_a(pos)), new ForgedContainerProcessor(settings.func_189947_a(pos)), new TransferUnitProcessor(settings.func_189947_a(pos))});
        template.func_189960_a(world, pos, (ITemplateProcessor)processors, settings, 2);
        this.generateLoot(feature, template, world, pos, settings, random);
        if (depth < ConfigHandler.maxFeatureDepth) {
            this.generateChildren(feature, world, pos, rotation, mirror, random, depth);
        }
    }

    private void generateChildren(GenerationFeature feature, World world, BlockPos pos, Rotation rotation, Mirror mirror, Random random, int depth) {
        Arrays.stream(feature.children).filter(child -> child.chance == 1.0f || random.nextFloat() < child.chance).forEach(child -> {
            ResourceLocation selectedLocation = child.features[random.nextInt(child.features.length)];
            GenerationFeature selectedFeature = this.getFeature(selectedLocation);
            if (selectedFeature != null) {
                Rotation childRotation = rotation.func_185830_a(RotationHelper.rotationFromFacing(child.facing));
                PlacementSettings offsetPlacement = new PlacementSettings().func_186214_a(mirror).func_186220_a(rotation);
                PlacementSettings originPlacement = new PlacementSettings().func_186214_a(mirror).func_186220_a(childRotation);
                BlockPos childPos = Template.func_186266_a((PlacementSettings)offsetPlacement, (BlockPos)child.offset).func_177973_b((Vec3i)Template.func_186266_a((PlacementSettings)originPlacement, (BlockPos)selectedFeature.origin)).func_177971_a((Vec3i)pos);
                this.generateFeature(selectedFeature, world, childPos, childRotation, mirror, random, depth + 1);
            }
        });
    }

    private BlockPos adjustRootPosition(GenerationFeature feature, World world, BlockPos blockPos, Rotation rotation) {
        Template template = this.templateManager.func_186237_a(world.func_73046_m(), feature.location);
        BlockPos size = template.func_186259_a();
        size = size.func_190942_a(rotation);
        BlockPos offset = new BlockPos(16 - Math.abs(size.func_177958_n()) / 2, 0, 16 - Math.abs(size.func_177952_p()) / 2);
        return blockPos.func_177971_a((Vec3i)offset);
    }

    private void generateLoot(GenerationFeature feature, Template template, World world, BlockPos pos, PlacementSettings settings, Random random) {
        template.func_186258_a(pos, settings).entrySet().stream().filter(entry -> ((String)entry.getValue()).startsWith("loot=")).forEach(entry -> {
            ResourceLocation lootLocation = new ResourceLocation(((String)entry.getValue()).substring(5));
            this.addLoot(lootLocation, world, ((BlockPos)entry.getKey()).func_177977_b(), random);
        });
        Arrays.stream(feature.loot).forEach(loot -> this.addLoot(loot.table, world, Template.func_186266_a((PlacementSettings)settings, (BlockPos)loot.position).func_177971_a((Vec3i)pos), random));
    }

    private void addLoot(ResourceLocation lootLocation, World world, BlockPos pos, Random random) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLockableLoot) {
            ((TileEntityLockableLoot)tileEntity).func_189404_a(lootLocation, random.nextLong());
        } else if (tileEntity instanceof IInventory) {
            LootTable lootTable = world.func_184146_ak().func_186521_a(lootLocation);
            LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
            lootTable.func_186460_a((IInventory)tileEntity, random, builder.func_186471_a());
        }
    }
}

