/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ItemLayerModel;
import se.mickelus.tetra.NBTHelper;
import se.mickelus.tetra.client.model.BakedWrapper;
import se.mickelus.tetra.items.ItemModular;

public class ModularOverrideList
extends ItemOverrideList {
    private Cache<CacheKey, IBakedModel> bakedModelCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    static ModularOverrideList INSTANCE = new ModularOverrideList();

    protected ModularOverrideList() {
        super((List)ImmutableList.of());
    }

    @Nonnull
    public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
        NBTTagCompound baseTag = NBTHelper.getTag(stack);
        IBakedModel result = originalModel;
        if (!baseTag.func_82582_d()) {
            CacheKey key = this.getCacheKey(stack, originalModel);
            try {
                result = (IBakedModel)this.bakedModelCache.get((Object)key, () -> this.getOverrideModel(stack, world, entity, originalModel));
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected CacheKey getCacheKey(ItemStack stack, IBakedModel original) {
        return new CacheKey(original, stack);
    }

    protected IBakedModel getOverrideModel(ItemStack itemStack, World world, EntityLivingBase entity, IBakedModel original) {
        ItemModular item = (ItemModular)itemStack.func_77973_b();
        BakedWrapper wrapper = (BakedWrapper)original;
        ImmutableList<ResourceLocation> textures = item.getTextures(itemStack);
        return new ItemLayerModel(textures).bake(wrapper.getOriginalState(), wrapper.getOriginalFormat(), wrapper.getBakedTextureGetter());
    }

    protected static class CacheKey {
        final IBakedModel parent;
        final String data;

        protected CacheKey(IBakedModel parent, ItemStack stack) {
            this.parent = parent;
            this.data = this.getDataFromStack(stack);
        }

        protected String getDataFromStack(ItemStack stack) {
            return NBTHelper.getTag(stack).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.parent != null ? this.parent != cacheKey.parent : cacheKey.parent != null) {
                return false;
            }
            return this.data != null ? this.data.equals(cacheKey.data) : cacheKey.data == null;
        }

        public int hashCode() {
            int result = this.parent != null ? this.parent.hashCode() : 0;
            result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
            return result;
        }
    }
}

