/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.GuiRect;

public class GuiModuleImprovement
extends GuiElement {
    private final List<String> tooltipLines;
    private Runnable hoverHandler;
    private Runnable blurHandler;

    public GuiModuleImprovement(int x, int y, String improvement, int level, int color, Runnable hoverHandler, Runnable blurHandler) {
        super(x, y, 4, 4);
        this.addChild(new GuiRect(0, 1, this.width, 1, color));
        this.tooltipLines = new ArrayList<String>();
        if (level < 0) {
            this.tooltipLines.add(ChatFormatting.DARK_RED + "-" + I18n.func_135052_a((String)(improvement + ".name"), (Object[])new Object[]{""}));
        } else if (level == 0) {
            this.tooltipLines.add(I18n.func_135052_a((String)(improvement + ".name"), (Object[])new Object[0]));
        } else {
            this.tooltipLines.add(I18n.func_135052_a((String)(improvement + ".name"), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("enchantment.level." + level), (Object[])new Object[0]));
        }
        Arrays.stream(I18n.func_135052_a((String)(improvement + ".description"), (Object[])new Object[0]).split("\\\\n")).map(line -> line.replace(ChatFormatting.RESET.toString(), ChatFormatting.DARK_GRAY.toString())).map(line -> ChatFormatting.DARK_GRAY + line).forEachOrdered(this.tooltipLines::add);
        this.hoverHandler = hoverHandler;
        this.blurHandler = blurHandler;
    }

    @Override
    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltipLines;
        }
        return null;
    }

    @Override
    protected void onFocus() {
        super.onFocus();
        this.hoverHandler.run();
    }

    @Override
    protected void onBlur() {
        super.onBlur();
        this.blurHandler.run();
    }
}

