/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import se.mickelus.tetra.blocks.workbench.gui.GuiModuleGlyph;
import se.mickelus.tetra.gui.GuiAttachment;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.GuiItem;
import se.mickelus.tetra.gui.GuiString;
import se.mickelus.tetra.gui.GuiStringSmall;
import se.mickelus.tetra.gui.GuiTextSmall;
import se.mickelus.tetra.gui.GuiTexture;
import se.mickelus.tetra.gui.impl.GuiMagicUsage;
import se.mickelus.tetra.gui.impl.GuiSettleProgress;
import se.mickelus.tetra.gui.impl.GuiSynergyIndicator;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.data.ModuleData;
import se.mickelus.tetra.module.schema.RepairDefinition;

public class GuiModuleDetails
extends GuiElement {
    private GuiElement glyph = new GuiElement(3, 3, 16, 16);
    private GuiString title;
    private GuiTextSmall description;
    private GuiString emptyLabel;
    private GuiMagicUsage magicBar;
    private GuiSettleProgress settleBar;
    private GuiSynergyIndicator synergyIndicator;
    private GuiElement repairGroup;
    private GuiStringSmall repairTitle;
    private GuiItem repairMaterial;
    private GuiStringSmall noRepairLabel;

    public GuiModuleDetails(int x, int y) {
        super(x, y, 224, 67);
        this.addChild(this.glyph);
        this.title = new GuiString(20, 7, 105, "");
        this.addChild(this.title);
        this.description = new GuiTextSmall(5, 19, 105, "");
        this.addChild(this.description);
        this.emptyLabel = new GuiString(0, -3, TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"workbench.module_detail.empty", (Object[])new Object[0]));
        this.emptyLabel.setAttachment(GuiAttachment.middleCenter);
        this.addChild(this.emptyLabel);
        this.synergyIndicator = new GuiSynergyIndicator(130, 8);
        this.addChild(this.synergyIndicator);
        this.repairGroup = new GuiElement(150, 5, 60, 16);
        this.addChild(this.repairGroup);
        this.repairTitle = new GuiStringSmall(0, 7, I18n.func_135052_a((String)"item.modular.repair_material.label", (Object[])new Object[0]));
        this.repairGroup.addChild(this.repairTitle);
        this.noRepairLabel = new GuiStringSmall(0, 7, TextFormatting.GRAY + I18n.func_135052_a((String)"item.modular.repair_material.empty", (Object[])new Object[0]));
        this.noRepairLabel.setAttachment(GuiAttachment.topCenter);
        this.noRepairLabel.setVisible(false);
        this.repairGroup.addChild(this.noRepairLabel);
        this.repairMaterial = new GuiItem(-2, 0);
        this.repairMaterial.setAttachment(GuiAttachment.topRight);
        this.repairGroup.addChild(this.repairMaterial);
        this.magicBar = new GuiMagicUsage(130, 30, 80);
        this.addChild(this.magicBar);
        this.settleBar = new GuiSettleProgress(130, 45, 80);
        this.addChild(this.settleBar);
    }

    public void update(ItemModule module, ItemStack itemStack) {
        this.glyph.clearChildren();
        if (module != null) {
            boolean canRepair;
            this.title.setString(module.getName(itemStack));
            this.description.setString(module.getDescription(itemStack));
            GlyphData glyphData = ((ModuleData)module.getData((ItemStack)itemStack)).glyph;
            if (module instanceof ItemModuleMajor) {
                this.glyph.addChild(new GuiTexture(0, 0, 15, 15, 52, 0, "textures/gui/workbench.png"));
                this.glyph.addChild(new GuiModuleGlyph(-1, 0, 16, 16, glyphData).setShift(false));
                this.settleBar.update(itemStack, (ItemModuleMajor)module);
            } else {
                this.glyph.addChild(new GuiTexture(3, 2, 11, 11, 68, 0, "textures/gui/workbench.png"));
                this.glyph.addChild(new GuiModuleGlyph(5, 4, 8, 8, glyphData).setShift(false));
            }
            this.magicBar.update(itemStack, ItemStack.field_190927_a, module.getSlot());
            this.synergyIndicator.update(itemStack, module);
            RepairDefinition repairDefinition = ItemUpgradeRegistry.instance.getRepairDefinition(((ModuleData)module.getData((ItemStack)itemStack)).key);
            boolean bl = canRepair = repairDefinition != null && repairDefinition.material.getApplicableItemstacks().length > 0;
            if (canRepair) {
                this.repairMaterial.setItem(repairDefinition.material.getApplicableItemstacks()[0]);
            }
            this.repairTitle.setVisible(canRepair);
            this.repairMaterial.setVisible(canRepair);
            this.noRepairLabel.setVisible(!canRepair);
        }
        this.synergyIndicator.setVisible(module != null);
        this.title.setVisible(module != null);
        this.description.setVisible(module != null);
        this.settleBar.setVisible(module instanceof ItemModuleMajor);
        this.magicBar.setVisible(module instanceof ItemModuleMajor);
        this.emptyLabel.setVisible(module == null);
        this.repairGroup.setVisible(module != null);
    }
}

