/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import se.mickelus.tetra.gui.GuiAttachment;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.gui.GuiString;
import se.mickelus.tetra.gui.GuiStringSmall;
import se.mickelus.tetra.gui.animation.Applier;
import se.mickelus.tetra.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.items.ItemModular;

public class GuiIntegrityBar
extends GuiElement {
    private static final int segmentWidth = 8;
    private static final int segmentHeight = 2;
    private static final int segmentOffset = 6;
    private static final int gainColor = 0x22FFFFFF;
    private static final int costColor = -1;
    private static final int overuseColor = -1996532395;
    private int integrityGain;
    private int integrityCost;
    private GuiString label = new GuiStringSmall(0, 0, "");
    private List<String> tooltip;

    public GuiIntegrityBar(int x, int y) {
        super(x, y, 0, 8);
        this.label.setAttachment(GuiAttachment.topCenter);
        this.addChild(this.label);
        this.setAttachmentPoint(GuiAttachment.topCenter);
        this.tooltip = Collections.singletonList(I18n.func_135052_a((String)"stats.integrity_usage.tooltip", (Object[])new Object[0]));
    }

    public void setItemStack(ItemStack itemStack, ItemStack previewStack) {
        boolean shouldShow = !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemModular;
        this.setVisible(shouldShow);
        if (shouldShow) {
            if (!previewStack.func_190926_b()) {
                this.integrityGain = ItemModular.getIntegrityGain(previewStack);
                this.integrityCost = ItemModular.getIntegrityCost(previewStack);
            } else {
                this.integrityGain = ItemModular.getIntegrityGain(itemStack);
                this.integrityCost = ItemModular.getIntegrityCost(itemStack);
            }
            if (this.integrityGain + this.integrityCost < 0) {
                this.label.setString(TextFormatting.RED + I18n.func_135052_a((String)"stats.integrity_usage", (Object[])new Object[]{-this.integrityCost, this.integrityGain}));
            } else {
                this.label.setString(I18n.func_135052_a((String)"stats.integrity_usage", (Object[])new Object[]{-this.integrityCost, this.integrityGain}));
            }
            this.width = this.integrityGain * 9;
        }
    }

    public void showAnimation() {
        if (this.isVisible()) {
            new KeyframeAnimation(100, this).withDelay(200).applyTo(new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateY(-3.0f, 0.0f, true)).start();
        }
    }

    @Override
    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltip;
        }
        return super.getTooltipLines();
    }

    @Override
    public void draw(int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        int i;
        super.draw(refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        for (i = 0; i < -this.integrityCost; ++i) {
            this.drawSegment(refX + this.x + i * 9, refY + this.y + 6, GuiIntegrityBar.colorWithOpacity(i >= this.integrityGain ? -1996532395 : -1, opacity * this.getOpacity()));
        }
        for (i = -this.integrityCost; i < this.integrityGain; ++i) {
            this.drawSegment(refX + this.x + i * 9, refY + this.y + 6, GuiIntegrityBar.colorWithOpacity(0x22FFFFFF, opacity * this.getOpacity()));
        }
    }

    private void drawSegment(int x, int y, int color) {
        GuiIntegrityBar.func_73734_a((int)x, (int)y, (int)(x + 8), (int)(y + 2), (int)color);
    }
}

