/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.Collection;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.blocks.workbench.gui.GuiCapabilityRequirement;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.gui.GuiAttachment;
import se.mickelus.tetra.gui.GuiElement;
import se.mickelus.tetra.module.schema.UpgradeSchema;

public class GuiCapabilityRequirementList
extends GuiElement {
    private GuiCapabilityRequirement[] indicators;
    private int[] requiredLevels;

    public GuiCapabilityRequirementList(int x, int y) {
        super(x, y, 54, 18);
        Capability[] capabilities = Capability.values();
        this.indicators = new GuiCapabilityRequirement[capabilities.length];
        for (int i = 0; i < capabilities.length; ++i) {
            this.indicators[i] = new GuiCapabilityRequirement(0, 0, capabilities[i]);
            this.indicators[i].setAttachment(GuiAttachment.topRight);
            this.addChild(this.indicators[i]);
        }
        this.requiredLevels = new int[this.indicators.length];
    }

    public void update(UpgradeSchema schema, ItemStack targetStack, ItemStack[] materials, int[] availableCapabilities) {
        this.setVisible(schema.isMaterialsValid(targetStack, materials));
        int visibleCount = 0;
        Capability[] capabilities = Capability.values();
        Collection<Capability> requiredCapabilities = schema.getRequiredCapabilities(targetStack, materials);
        for (int i = 0; i < capabilities.length; ++i) {
            this.requiredLevels[i] = schema.getRequiredCapabilityLevel(targetStack, materials, capabilities[i]);
            if (requiredCapabilities.contains((Object)capabilities[i]) && this.requiredLevels[i] > 0) {
                this.indicators[i].setX(-visibleCount * this.indicators[i].getWidth());
                this.indicators[i].updateRequirement(this.requiredLevels[i], availableCapabilities[i]);
                this.indicators[i].setVisible(true);
                ++visibleCount;
                continue;
            }
            this.indicators[i].setVisible(false);
        }
    }

    public void updateAvailableCapabilities(int[] availableCapabilities) {
        for (int i = 0; i < this.indicators.length; ++i) {
            if (this.requiredLevels[i] <= 0) continue;
            this.indicators[i].updateRequirement(this.requiredLevels[i], availableCapabilities[i]);
        }
    }
}

